// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediatailor.model

import aws.smithy.kotlin.runtime.SdkDsl

public class PutPlaybackConfigurationRequest private constructor(builder: Builder) {
    /**
     * The setting that indicates what conditioning MediaTailor will perform on ads that the ad decision server (ADS) returns, and what priority MediaTailor uses when inserting ads.
     */
    public val adConditioningConfiguration: aws.sdk.kotlin.services.mediatailor.model.AdConditioningConfiguration? = builder.adConditioningConfiguration
    /**
     * The URL for the ad decision server (ADS). This includes the specification of static parameters and placeholders for dynamic parameters. AWS Elemental MediaTailor substitutes player-specific and session-specific parameters as needed when calling the ADS. Alternately, for testing you can provide a static VAST URL. The maximum length is 25,000 characters.
     */
    public val adDecisionServerUrl: kotlin.String? = builder.adDecisionServerUrl
    /**
     * The configuration for avail suppression, also known as ad suppression. For more information about ad suppression, see [Ad Suppression](https://docs.aws.amazon.com/mediatailor/latest/ug/ad-behavior.html).
     */
    public val availSuppression: aws.sdk.kotlin.services.mediatailor.model.AvailSuppression? = builder.availSuppression
    /**
     * The configuration for bumpers. Bumpers are short audio or video clips that play at the start or before the end of an ad break. To learn more about bumpers, see [Bumpers](https://docs.aws.amazon.com/mediatailor/latest/ug/bumpers.html).
     */
    public val bumper: aws.sdk.kotlin.services.mediatailor.model.Bumper? = builder.bumper
    /**
     * The configuration for using a content delivery network (CDN), like Amazon CloudFront, for content and ad segment management.
     */
    public val cdnConfiguration: aws.sdk.kotlin.services.mediatailor.model.CdnConfiguration? = builder.cdnConfiguration
    /**
     * The player parameters and aliases used as dynamic variables during session initialization. For more information, see [Domain Variables](https://docs.aws.amazon.com/mediatailor/latest/ug/variables-domains.html).
     */
    public val configurationAliases: Map<String, Map<String, String>>? = builder.configurationAliases
    /**
     * The configuration for DASH content.
     */
    public val dashConfiguration: aws.sdk.kotlin.services.mediatailor.model.DashConfigurationForPut? = builder.dashConfiguration
    /**
     * The setting that controls whether players can use stitched or guided ad insertion. The default, `STITCHED_ONLY`, forces all player sessions to use stitched (server-side) ad insertion. Choosing `PLAYER_SELECT` allows players to select either stitched or guided ad insertion at session-initialization time. The default for players that do not specify an insertion mode is stitched.
     */
    public val insertionMode: aws.sdk.kotlin.services.mediatailor.model.InsertionMode = builder.insertionMode
    /**
     * The configuration for pre-roll ad insertion.
     */
    public val livePreRollConfiguration: aws.sdk.kotlin.services.mediatailor.model.LivePreRollConfiguration? = builder.livePreRollConfiguration
    /**
     * The configuration for manifest processing rules. Manifest processing rules enable customization of the personalized manifests created by MediaTailor.
     */
    public val manifestProcessingRules: aws.sdk.kotlin.services.mediatailor.model.ManifestProcessingRules? = builder.manifestProcessingRules
    /**
     * The identifier for the playback configuration.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * Defines the maximum duration of underfilled ad time (in seconds) allowed in an ad break. If the duration of underfilled ad time exceeds the personalization threshold, then the personalization of the ad break is abandoned and the underlying content is shown. This feature applies to *ad replacement* in live and VOD streams, rather than ad insertion, because it relies on an underlying content stream. For more information about ad break behavior, including ad replacement and insertion, see [Ad Behavior in AWS Elemental MediaTailor](https://docs.aws.amazon.com/mediatailor/latest/ug/ad-behavior.html).
     */
    public val personalizationThresholdSeconds: kotlin.Int? = builder.personalizationThresholdSeconds
    /**
     * The URL for a high-quality video asset to transcode and use to fill in time that's not used by ads. AWS Elemental MediaTailor shows the slate to fill in gaps in media content. Configuring the slate is optional for non-VPAID configurations. For VPAID, the slate is required because MediaTailor provides it in the slots that are designated for dynamic ad content. The slate must be a high-quality asset that contains both audio and video.
     */
    public val slateAdUrl: kotlin.String? = builder.slateAdUrl
    /**
     * The tags to assign to the playback configuration. Tags are key-value pairs that you can associate with Amazon resources to help with organization, access control, and cost tracking. For more information, see [Tagging AWS Elemental MediaTailor Resources](https://docs.aws.amazon.com/mediatailor/latest/ug/tagging.html).
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The name that is used to associate this playback configuration with a custom transcode profile. This overrides the dynamic transcoding defaults of MediaTailor. Use this only if you have already set up custom profiles with the help of AWS Support.
     */
    public val transcodeProfileName: kotlin.String? = builder.transcodeProfileName
    /**
     * The URL prefix for the parent manifest for the stream, minus the asset ID. The maximum length is 512 characters.
     */
    public val videoContentSourceUrl: kotlin.String? = builder.videoContentSourceUrl

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediatailor.model.PutPlaybackConfigurationRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PutPlaybackConfigurationRequest(")
        append("adConditioningConfiguration=$adConditioningConfiguration,")
        append("adDecisionServerUrl=$adDecisionServerUrl,")
        append("availSuppression=$availSuppression,")
        append("bumper=$bumper,")
        append("cdnConfiguration=$cdnConfiguration,")
        append("configurationAliases=$configurationAliases,")
        append("dashConfiguration=$dashConfiguration,")
        append("insertionMode=$insertionMode,")
        append("livePreRollConfiguration=$livePreRollConfiguration,")
        append("manifestProcessingRules=$manifestProcessingRules,")
        append("name=$name,")
        append("personalizationThresholdSeconds=$personalizationThresholdSeconds,")
        append("slateAdUrl=$slateAdUrl,")
        append("tags=$tags,")
        append("transcodeProfileName=$transcodeProfileName,")
        append("videoContentSourceUrl=$videoContentSourceUrl")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = adConditioningConfiguration?.hashCode() ?: 0
        result = 31 * result + (adDecisionServerUrl?.hashCode() ?: 0)
        result = 31 * result + (availSuppression?.hashCode() ?: 0)
        result = 31 * result + (bumper?.hashCode() ?: 0)
        result = 31 * result + (cdnConfiguration?.hashCode() ?: 0)
        result = 31 * result + (configurationAliases?.hashCode() ?: 0)
        result = 31 * result + (dashConfiguration?.hashCode() ?: 0)
        result = 31 * result + (insertionMode.hashCode())
        result = 31 * result + (livePreRollConfiguration?.hashCode() ?: 0)
        result = 31 * result + (manifestProcessingRules?.hashCode() ?: 0)
        result = 31 * result + (name.hashCode())
        result = 31 * result + (personalizationThresholdSeconds ?: 0)
        result = 31 * result + (slateAdUrl?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (transcodeProfileName?.hashCode() ?: 0)
        result = 31 * result + (videoContentSourceUrl?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PutPlaybackConfigurationRequest

        if (adConditioningConfiguration != other.adConditioningConfiguration) return false
        if (adDecisionServerUrl != other.adDecisionServerUrl) return false
        if (availSuppression != other.availSuppression) return false
        if (bumper != other.bumper) return false
        if (cdnConfiguration != other.cdnConfiguration) return false
        if (configurationAliases != other.configurationAliases) return false
        if (dashConfiguration != other.dashConfiguration) return false
        if (insertionMode != other.insertionMode) return false
        if (livePreRollConfiguration != other.livePreRollConfiguration) return false
        if (manifestProcessingRules != other.manifestProcessingRules) return false
        if (name != other.name) return false
        if (personalizationThresholdSeconds != other.personalizationThresholdSeconds) return false
        if (slateAdUrl != other.slateAdUrl) return false
        if (tags != other.tags) return false
        if (transcodeProfileName != other.transcodeProfileName) return false
        if (videoContentSourceUrl != other.videoContentSourceUrl) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediatailor.model.PutPlaybackConfigurationRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The setting that indicates what conditioning MediaTailor will perform on ads that the ad decision server (ADS) returns, and what priority MediaTailor uses when inserting ads.
         */
        public var adConditioningConfiguration: aws.sdk.kotlin.services.mediatailor.model.AdConditioningConfiguration? = null
        /**
         * The URL for the ad decision server (ADS). This includes the specification of static parameters and placeholders for dynamic parameters. AWS Elemental MediaTailor substitutes player-specific and session-specific parameters as needed when calling the ADS. Alternately, for testing you can provide a static VAST URL. The maximum length is 25,000 characters.
         */
        public var adDecisionServerUrl: kotlin.String? = null
        /**
         * The configuration for avail suppression, also known as ad suppression. For more information about ad suppression, see [Ad Suppression](https://docs.aws.amazon.com/mediatailor/latest/ug/ad-behavior.html).
         */
        public var availSuppression: aws.sdk.kotlin.services.mediatailor.model.AvailSuppression? = null
        /**
         * The configuration for bumpers. Bumpers are short audio or video clips that play at the start or before the end of an ad break. To learn more about bumpers, see [Bumpers](https://docs.aws.amazon.com/mediatailor/latest/ug/bumpers.html).
         */
        public var bumper: aws.sdk.kotlin.services.mediatailor.model.Bumper? = null
        /**
         * The configuration for using a content delivery network (CDN), like Amazon CloudFront, for content and ad segment management.
         */
        public var cdnConfiguration: aws.sdk.kotlin.services.mediatailor.model.CdnConfiguration? = null
        /**
         * The player parameters and aliases used as dynamic variables during session initialization. For more information, see [Domain Variables](https://docs.aws.amazon.com/mediatailor/latest/ug/variables-domains.html).
         */
        public var configurationAliases: Map<String, Map<String, String>>? = null
        /**
         * The configuration for DASH content.
         */
        public var dashConfiguration: aws.sdk.kotlin.services.mediatailor.model.DashConfigurationForPut? = null
        /**
         * The setting that controls whether players can use stitched or guided ad insertion. The default, `STITCHED_ONLY`, forces all player sessions to use stitched (server-side) ad insertion. Choosing `PLAYER_SELECT` allows players to select either stitched or guided ad insertion at session-initialization time. The default for players that do not specify an insertion mode is stitched.
         */
        public var insertionMode: aws.sdk.kotlin.services.mediatailor.model.InsertionMode = aws.sdk.kotlin.services.mediatailor.model.InsertionMode.fromValue("STITCHED_ONLY")
        /**
         * The configuration for pre-roll ad insertion.
         */
        public var livePreRollConfiguration: aws.sdk.kotlin.services.mediatailor.model.LivePreRollConfiguration? = null
        /**
         * The configuration for manifest processing rules. Manifest processing rules enable customization of the personalized manifests created by MediaTailor.
         */
        public var manifestProcessingRules: aws.sdk.kotlin.services.mediatailor.model.ManifestProcessingRules? = null
        /**
         * The identifier for the playback configuration.
         */
        public var name: kotlin.String? = null
        /**
         * Defines the maximum duration of underfilled ad time (in seconds) allowed in an ad break. If the duration of underfilled ad time exceeds the personalization threshold, then the personalization of the ad break is abandoned and the underlying content is shown. This feature applies to *ad replacement* in live and VOD streams, rather than ad insertion, because it relies on an underlying content stream. For more information about ad break behavior, including ad replacement and insertion, see [Ad Behavior in AWS Elemental MediaTailor](https://docs.aws.amazon.com/mediatailor/latest/ug/ad-behavior.html).
         */
        public var personalizationThresholdSeconds: kotlin.Int? = null
        /**
         * The URL for a high-quality video asset to transcode and use to fill in time that's not used by ads. AWS Elemental MediaTailor shows the slate to fill in gaps in media content. Configuring the slate is optional for non-VPAID configurations. For VPAID, the slate is required because MediaTailor provides it in the slots that are designated for dynamic ad content. The slate must be a high-quality asset that contains both audio and video.
         */
        public var slateAdUrl: kotlin.String? = null
        /**
         * The tags to assign to the playback configuration. Tags are key-value pairs that you can associate with Amazon resources to help with organization, access control, and cost tracking. For more information, see [Tagging AWS Elemental MediaTailor Resources](https://docs.aws.amazon.com/mediatailor/latest/ug/tagging.html).
         */
        public var tags: Map<String, String>? = null
        /**
         * The name that is used to associate this playback configuration with a custom transcode profile. This overrides the dynamic transcoding defaults of MediaTailor. Use this only if you have already set up custom profiles with the help of AWS Support.
         */
        public var transcodeProfileName: kotlin.String? = null
        /**
         * The URL prefix for the parent manifest for the stream, minus the asset ID. The maximum length is 512 characters.
         */
        public var videoContentSourceUrl: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediatailor.model.PutPlaybackConfigurationRequest) : this() {
            this.adConditioningConfiguration = x.adConditioningConfiguration
            this.adDecisionServerUrl = x.adDecisionServerUrl
            this.availSuppression = x.availSuppression
            this.bumper = x.bumper
            this.cdnConfiguration = x.cdnConfiguration
            this.configurationAliases = x.configurationAliases
            this.dashConfiguration = x.dashConfiguration
            this.insertionMode = x.insertionMode
            this.livePreRollConfiguration = x.livePreRollConfiguration
            this.manifestProcessingRules = x.manifestProcessingRules
            this.name = x.name
            this.personalizationThresholdSeconds = x.personalizationThresholdSeconds
            this.slateAdUrl = x.slateAdUrl
            this.tags = x.tags
            this.transcodeProfileName = x.transcodeProfileName
            this.videoContentSourceUrl = x.videoContentSourceUrl
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediatailor.model.PutPlaybackConfigurationRequest = PutPlaybackConfigurationRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.mediatailor.model.AdConditioningConfiguration] inside the given [block]
         */
        public fun adConditioningConfiguration(block: aws.sdk.kotlin.services.mediatailor.model.AdConditioningConfiguration.Builder.() -> kotlin.Unit) {
            this.adConditioningConfiguration = aws.sdk.kotlin.services.mediatailor.model.AdConditioningConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediatailor.model.AvailSuppression] inside the given [block]
         */
        public fun availSuppression(block: aws.sdk.kotlin.services.mediatailor.model.AvailSuppression.Builder.() -> kotlin.Unit) {
            this.availSuppression = aws.sdk.kotlin.services.mediatailor.model.AvailSuppression.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediatailor.model.Bumper] inside the given [block]
         */
        public fun bumper(block: aws.sdk.kotlin.services.mediatailor.model.Bumper.Builder.() -> kotlin.Unit) {
            this.bumper = aws.sdk.kotlin.services.mediatailor.model.Bumper.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediatailor.model.CdnConfiguration] inside the given [block]
         */
        public fun cdnConfiguration(block: aws.sdk.kotlin.services.mediatailor.model.CdnConfiguration.Builder.() -> kotlin.Unit) {
            this.cdnConfiguration = aws.sdk.kotlin.services.mediatailor.model.CdnConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediatailor.model.DashConfigurationForPut] inside the given [block]
         */
        public fun dashConfiguration(block: aws.sdk.kotlin.services.mediatailor.model.DashConfigurationForPut.Builder.() -> kotlin.Unit) {
            this.dashConfiguration = aws.sdk.kotlin.services.mediatailor.model.DashConfigurationForPut.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediatailor.model.LivePreRollConfiguration] inside the given [block]
         */
        public fun livePreRollConfiguration(block: aws.sdk.kotlin.services.mediatailor.model.LivePreRollConfiguration.Builder.() -> kotlin.Unit) {
            this.livePreRollConfiguration = aws.sdk.kotlin.services.mediatailor.model.LivePreRollConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediatailor.model.ManifestProcessingRules] inside the given [block]
         */
        public fun manifestProcessingRules(block: aws.sdk.kotlin.services.mediatailor.model.ManifestProcessingRules.Builder.() -> kotlin.Unit) {
            this.manifestProcessingRules = aws.sdk.kotlin.services.mediatailor.model.ManifestProcessingRules.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (name == null) name = ""
            return this
        }
    }
}
