// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediatailor.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Configures Amazon CloudWatch log settings for a playback configuration.
 */
public class ConfigureLogsForPlaybackConfigurationRequest private constructor(builder: Builder) {
    /**
     * The method used for collecting logs from AWS Elemental MediaTailor. To configure MediaTailor to send logs directly to Amazon CloudWatch Logs, choose `LEGACY_CLOUDWATCH`. To configure MediaTailor to send logs to CloudWatch, which then vends the logs to your destination of choice, choose `VENDED_LOGS`. Supported destinations are CloudWatch Logs log group, Amazon S3 bucket, and Amazon Data Firehose stream.
     *
     * To use vended logs, you must configure the delivery destination in Amazon CloudWatch, as described in [Enable logging from AWS services, Logging that requires additional permissions &#91;V2&#93;](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/AWS-logs-and-resource-policy.html#AWS-vended-logs-permissions-V2).
     */
    public val enabledLoggingStrategies: List<LoggingStrategy>? = builder.enabledLoggingStrategies
    /**
     * The percentage of session logs that MediaTailor sends to your CloudWatch Logs account. For example, if your playback configuration has 1000 sessions and percentEnabled is set to `60`, MediaTailor sends logs for 600 of the sessions to CloudWatch Logs. MediaTailor decides at random which of the playback configuration sessions to send logs for. If you want to view logs for a specific session, you can use the [debug log mode](https://docs.aws.amazon.com/mediatailor/latest/ug/debug-log-mode.html).
     *
     * Valid values: `0` - `100`
     */
    public val percentEnabled: kotlin.Int = builder.percentEnabled
    /**
     * The name of the playback configuration.
     */
    public val playbackConfigurationName: kotlin.String = requireNotNull(builder.playbackConfigurationName) { "A non-null value must be provided for playbackConfigurationName" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediatailor.model.ConfigureLogsForPlaybackConfigurationRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ConfigureLogsForPlaybackConfigurationRequest(")
        append("enabledLoggingStrategies=$enabledLoggingStrategies,")
        append("percentEnabled=$percentEnabled,")
        append("playbackConfigurationName=$playbackConfigurationName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = enabledLoggingStrategies?.hashCode() ?: 0
        result = 31 * result + (percentEnabled)
        result = 31 * result + (playbackConfigurationName.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ConfigureLogsForPlaybackConfigurationRequest

        if (enabledLoggingStrategies != other.enabledLoggingStrategies) return false
        if (percentEnabled != other.percentEnabled) return false
        if (playbackConfigurationName != other.playbackConfigurationName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediatailor.model.ConfigureLogsForPlaybackConfigurationRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The method used for collecting logs from AWS Elemental MediaTailor. To configure MediaTailor to send logs directly to Amazon CloudWatch Logs, choose `LEGACY_CLOUDWATCH`. To configure MediaTailor to send logs to CloudWatch, which then vends the logs to your destination of choice, choose `VENDED_LOGS`. Supported destinations are CloudWatch Logs log group, Amazon S3 bucket, and Amazon Data Firehose stream.
         *
         * To use vended logs, you must configure the delivery destination in Amazon CloudWatch, as described in [Enable logging from AWS services, Logging that requires additional permissions &#91;V2&#93;](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/AWS-logs-and-resource-policy.html#AWS-vended-logs-permissions-V2).
         */
        public var enabledLoggingStrategies: List<LoggingStrategy>? = null
        /**
         * The percentage of session logs that MediaTailor sends to your CloudWatch Logs account. For example, if your playback configuration has 1000 sessions and percentEnabled is set to `60`, MediaTailor sends logs for 600 of the sessions to CloudWatch Logs. MediaTailor decides at random which of the playback configuration sessions to send logs for. If you want to view logs for a specific session, you can use the [debug log mode](https://docs.aws.amazon.com/mediatailor/latest/ug/debug-log-mode.html).
         *
         * Valid values: `0` - `100`
         */
        public var percentEnabled: kotlin.Int = 0
        /**
         * The name of the playback configuration.
         */
        public var playbackConfigurationName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediatailor.model.ConfigureLogsForPlaybackConfigurationRequest) : this() {
            this.enabledLoggingStrategies = x.enabledLoggingStrategies
            this.percentEnabled = x.percentEnabled
            this.playbackConfigurationName = x.playbackConfigurationName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediatailor.model.ConfigureLogsForPlaybackConfigurationRequest = ConfigureLogsForPlaybackConfigurationRequest(this)

        internal fun correctErrors(): Builder {
            if (playbackConfigurationName == null) playbackConfigurationName = ""
            return this
        }
    }
}
