// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediatailor.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * MediaTailor only places (consumes) prefetched ads if the ad break meets the criteria defined by the dynamic variables. This gives you granular control over which ad break to place the prefetched ads into.
 *
 * As an example, let's say that you set `DynamicVariable` to `scte.event_id` and `Operator` to `EQUALS`, and your playback configuration has an ADS URL of `https://my.ads.server.com/path?&amp;podId=[scte.avail_num]&amp;event=[scte.event_id]&amp;duration=[session.avail_duration_secs]`. And the prefetch request to the ADS contains these values `https://my.ads.server.com/path?&amp;podId=3&amp;event=my-awesome-event&amp;duration=30`. MediaTailor will only insert the prefetched ads into the ad break if has a SCTE marker with an event id of `my-awesome-event`, since it must match the event id that MediaTailor uses to query the ADS.
 *
 * You can specify up to five `AvailMatchingCriteria`. If you specify multiple `AvailMatchingCriteria`, MediaTailor combines them to match using a logical `AND`. You can model logical `OR` combinations by creating multiple prefetch schedules.
 */
public class AvailMatchingCriteria private constructor(builder: Builder) {
    /**
     * The dynamic variable(s) that MediaTailor should use as avail matching criteria. MediaTailor only places the prefetched ads into the avail if the avail matches the criteria defined by the dynamic variable. For information about dynamic variables, see [Using dynamic ad variables](https://docs.aws.amazon.com/mediatailor/latest/ug/variables.html) in the *MediaTailor User Guide*.
     *
     * You can include up to 100 dynamic variables.
     */
    public val dynamicVariable: kotlin.String = requireNotNull(builder.dynamicVariable) { "A non-null value must be provided for dynamicVariable" }
    /**
     * For the `DynamicVariable` specified in `AvailMatchingCriteria`, the Operator that is used for the comparison.
     */
    public val operator: aws.sdk.kotlin.services.mediatailor.model.Operator = requireNotNull(builder.operator) { "A non-null value must be provided for operator" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediatailor.model.AvailMatchingCriteria = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AvailMatchingCriteria(")
        append("dynamicVariable=$dynamicVariable,")
        append("operator=$operator")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dynamicVariable.hashCode()
        result = 31 * result + (operator.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AvailMatchingCriteria

        if (dynamicVariable != other.dynamicVariable) return false
        if (operator != other.operator) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediatailor.model.AvailMatchingCriteria = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The dynamic variable(s) that MediaTailor should use as avail matching criteria. MediaTailor only places the prefetched ads into the avail if the avail matches the criteria defined by the dynamic variable. For information about dynamic variables, see [Using dynamic ad variables](https://docs.aws.amazon.com/mediatailor/latest/ug/variables.html) in the *MediaTailor User Guide*.
         *
         * You can include up to 100 dynamic variables.
         */
        public var dynamicVariable: kotlin.String? = null
        /**
         * For the `DynamicVariable` specified in `AvailMatchingCriteria`, the Operator that is used for the comparison.
         */
        public var operator: aws.sdk.kotlin.services.mediatailor.model.Operator? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediatailor.model.AvailMatchingCriteria) : this() {
            this.dynamicVariable = x.dynamicVariable
            this.operator = x.operator
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediatailor.model.AvailMatchingCriteria = AvailMatchingCriteria(this)

        internal fun correctErrors(): Builder {
            if (dynamicVariable == null) dynamicVariable = ""
            if (operator == null) operator = Operator.SdkUnknown("no value provided")
            return this
        }
    }
}
