// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediatailor.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The setting that indicates what conditioning MediaTailor will perform on ads that the ad decision server (ADS) returns.
 */
public class AdConditioningConfiguration private constructor(builder: Builder) {
    /**
     * For ads that have media files with streaming delivery and supported file extensions, indicates what transcoding action MediaTailor takes when it first receives these ads from the ADS. `TRANSCODE` indicates that MediaTailor must transcode the ads. `NONE` indicates that you have already transcoded the ads outside of MediaTailor and don't need them transcoded as part of the ad insertion workflow. For more information about ad conditioning see [https://docs.aws.amazon.com/precondition-ads.html](https://docs.aws.amazon.com/precondition-ads.html).
     */
    public val streamingMediaFileConditioning: aws.sdk.kotlin.services.mediatailor.model.StreamingMediaFileConditioning = requireNotNull(builder.streamingMediaFileConditioning) { "A non-null value must be provided for streamingMediaFileConditioning" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediatailor.model.AdConditioningConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AdConditioningConfiguration(")
        append("streamingMediaFileConditioning=$streamingMediaFileConditioning")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = streamingMediaFileConditioning.hashCode()
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AdConditioningConfiguration

        if (streamingMediaFileConditioning != other.streamingMediaFileConditioning) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediatailor.model.AdConditioningConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * For ads that have media files with streaming delivery and supported file extensions, indicates what transcoding action MediaTailor takes when it first receives these ads from the ADS. `TRANSCODE` indicates that MediaTailor must transcode the ads. `NONE` indicates that you have already transcoded the ads outside of MediaTailor and don't need them transcoded as part of the ad insertion workflow. For more information about ad conditioning see [https://docs.aws.amazon.com/precondition-ads.html](https://docs.aws.amazon.com/precondition-ads.html).
         */
        public var streamingMediaFileConditioning: aws.sdk.kotlin.services.mediatailor.model.StreamingMediaFileConditioning? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediatailor.model.AdConditioningConfiguration) : this() {
            this.streamingMediaFileConditioning = x.streamingMediaFileConditioning
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediatailor.model.AdConditioningConfiguration = AdConditioningConfiguration(this)

        internal fun correctErrors(): Builder {
            if (streamingMediaFileConditioning == null) streamingMediaFileConditioning = StreamingMediaFileConditioning.SdkUnknown("no value provided")
            return this
        }
    }
}
