// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediatailor

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.mediatailor.auth.DefaultMediaTailorAuthSchemeProvider
import aws.sdk.kotlin.services.mediatailor.auth.MediaTailorAuthSchemeProvider
import aws.sdk.kotlin.services.mediatailor.endpoints.DefaultMediaTailorEndpointProvider
import aws.sdk.kotlin.services.mediatailor.endpoints.MediaTailorEndpointParameters
import aws.sdk.kotlin.services.mediatailor.endpoints.MediaTailorEndpointProvider
import aws.sdk.kotlin.services.mediatailor.model.ConfigureLogsForChannelRequest
import aws.sdk.kotlin.services.mediatailor.model.ConfigureLogsForChannelResponse
import aws.sdk.kotlin.services.mediatailor.model.ConfigureLogsForPlaybackConfigurationRequest
import aws.sdk.kotlin.services.mediatailor.model.ConfigureLogsForPlaybackConfigurationResponse
import aws.sdk.kotlin.services.mediatailor.model.CreateChannelRequest
import aws.sdk.kotlin.services.mediatailor.model.CreateChannelResponse
import aws.sdk.kotlin.services.mediatailor.model.CreateLiveSourceRequest
import aws.sdk.kotlin.services.mediatailor.model.CreateLiveSourceResponse
import aws.sdk.kotlin.services.mediatailor.model.CreatePrefetchScheduleRequest
import aws.sdk.kotlin.services.mediatailor.model.CreatePrefetchScheduleResponse
import aws.sdk.kotlin.services.mediatailor.model.CreateProgramRequest
import aws.sdk.kotlin.services.mediatailor.model.CreateProgramResponse
import aws.sdk.kotlin.services.mediatailor.model.CreateSourceLocationRequest
import aws.sdk.kotlin.services.mediatailor.model.CreateSourceLocationResponse
import aws.sdk.kotlin.services.mediatailor.model.CreateVodSourceRequest
import aws.sdk.kotlin.services.mediatailor.model.CreateVodSourceResponse
import aws.sdk.kotlin.services.mediatailor.model.DeleteChannelPolicyRequest
import aws.sdk.kotlin.services.mediatailor.model.DeleteChannelPolicyResponse
import aws.sdk.kotlin.services.mediatailor.model.DeleteChannelRequest
import aws.sdk.kotlin.services.mediatailor.model.DeleteChannelResponse
import aws.sdk.kotlin.services.mediatailor.model.DeleteLiveSourceRequest
import aws.sdk.kotlin.services.mediatailor.model.DeleteLiveSourceResponse
import aws.sdk.kotlin.services.mediatailor.model.DeletePlaybackConfigurationRequest
import aws.sdk.kotlin.services.mediatailor.model.DeletePlaybackConfigurationResponse
import aws.sdk.kotlin.services.mediatailor.model.DeletePrefetchScheduleRequest
import aws.sdk.kotlin.services.mediatailor.model.DeletePrefetchScheduleResponse
import aws.sdk.kotlin.services.mediatailor.model.DeleteProgramRequest
import aws.sdk.kotlin.services.mediatailor.model.DeleteProgramResponse
import aws.sdk.kotlin.services.mediatailor.model.DeleteSourceLocationRequest
import aws.sdk.kotlin.services.mediatailor.model.DeleteSourceLocationResponse
import aws.sdk.kotlin.services.mediatailor.model.DeleteVodSourceRequest
import aws.sdk.kotlin.services.mediatailor.model.DeleteVodSourceResponse
import aws.sdk.kotlin.services.mediatailor.model.DescribeChannelRequest
import aws.sdk.kotlin.services.mediatailor.model.DescribeChannelResponse
import aws.sdk.kotlin.services.mediatailor.model.DescribeLiveSourceRequest
import aws.sdk.kotlin.services.mediatailor.model.DescribeLiveSourceResponse
import aws.sdk.kotlin.services.mediatailor.model.DescribeProgramRequest
import aws.sdk.kotlin.services.mediatailor.model.DescribeProgramResponse
import aws.sdk.kotlin.services.mediatailor.model.DescribeSourceLocationRequest
import aws.sdk.kotlin.services.mediatailor.model.DescribeSourceLocationResponse
import aws.sdk.kotlin.services.mediatailor.model.DescribeVodSourceRequest
import aws.sdk.kotlin.services.mediatailor.model.DescribeVodSourceResponse
import aws.sdk.kotlin.services.mediatailor.model.GetChannelPolicyRequest
import aws.sdk.kotlin.services.mediatailor.model.GetChannelPolicyResponse
import aws.sdk.kotlin.services.mediatailor.model.GetChannelScheduleRequest
import aws.sdk.kotlin.services.mediatailor.model.GetChannelScheduleResponse
import aws.sdk.kotlin.services.mediatailor.model.GetPlaybackConfigurationRequest
import aws.sdk.kotlin.services.mediatailor.model.GetPlaybackConfigurationResponse
import aws.sdk.kotlin.services.mediatailor.model.GetPrefetchScheduleRequest
import aws.sdk.kotlin.services.mediatailor.model.GetPrefetchScheduleResponse
import aws.sdk.kotlin.services.mediatailor.model.ListAlertsRequest
import aws.sdk.kotlin.services.mediatailor.model.ListAlertsResponse
import aws.sdk.kotlin.services.mediatailor.model.ListChannelsRequest
import aws.sdk.kotlin.services.mediatailor.model.ListChannelsResponse
import aws.sdk.kotlin.services.mediatailor.model.ListLiveSourcesRequest
import aws.sdk.kotlin.services.mediatailor.model.ListLiveSourcesResponse
import aws.sdk.kotlin.services.mediatailor.model.ListPlaybackConfigurationsRequest
import aws.sdk.kotlin.services.mediatailor.model.ListPlaybackConfigurationsResponse
import aws.sdk.kotlin.services.mediatailor.model.ListPrefetchSchedulesRequest
import aws.sdk.kotlin.services.mediatailor.model.ListPrefetchSchedulesResponse
import aws.sdk.kotlin.services.mediatailor.model.ListSourceLocationsRequest
import aws.sdk.kotlin.services.mediatailor.model.ListSourceLocationsResponse
import aws.sdk.kotlin.services.mediatailor.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.mediatailor.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.mediatailor.model.ListVodSourcesRequest
import aws.sdk.kotlin.services.mediatailor.model.ListVodSourcesResponse
import aws.sdk.kotlin.services.mediatailor.model.PutChannelPolicyRequest
import aws.sdk.kotlin.services.mediatailor.model.PutChannelPolicyResponse
import aws.sdk.kotlin.services.mediatailor.model.PutPlaybackConfigurationRequest
import aws.sdk.kotlin.services.mediatailor.model.PutPlaybackConfigurationResponse
import aws.sdk.kotlin.services.mediatailor.model.StartChannelRequest
import aws.sdk.kotlin.services.mediatailor.model.StartChannelResponse
import aws.sdk.kotlin.services.mediatailor.model.StopChannelRequest
import aws.sdk.kotlin.services.mediatailor.model.StopChannelResponse
import aws.sdk.kotlin.services.mediatailor.model.TagResourceRequest
import aws.sdk.kotlin.services.mediatailor.model.TagResourceResponse
import aws.sdk.kotlin.services.mediatailor.model.UntagResourceRequest
import aws.sdk.kotlin.services.mediatailor.model.UntagResourceResponse
import aws.sdk.kotlin.services.mediatailor.model.UpdateChannelRequest
import aws.sdk.kotlin.services.mediatailor.model.UpdateChannelResponse
import aws.sdk.kotlin.services.mediatailor.model.UpdateLiveSourceRequest
import aws.sdk.kotlin.services.mediatailor.model.UpdateLiveSourceResponse
import aws.sdk.kotlin.services.mediatailor.model.UpdateProgramRequest
import aws.sdk.kotlin.services.mediatailor.model.UpdateProgramResponse
import aws.sdk.kotlin.services.mediatailor.model.UpdateSourceLocationRequest
import aws.sdk.kotlin.services.mediatailor.model.UpdateSourceLocationResponse
import aws.sdk.kotlin.services.mediatailor.model.UpdateVodSourceRequest
import aws.sdk.kotlin.services.mediatailor.model.UpdateVodSourceResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.AbstractSdkClientFactory
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "MediaTailor"
public const val SdkVersion: String = "1.4.38"
public const val ServiceApiVersion: String = "2018-04-23"

/**
 * Use the AWS Elemental MediaTailor SDKs and CLI to configure scalable ad insertion and linear channels. With MediaTailor, you can assemble existing content into a linear stream and serve targeted ads to viewers while maintaining broadcast quality in over-the-top (OTT) video applications. For information about using the service, including detailed information about the settings covered in this guide, see the [AWS Elemental MediaTailor User Guide](https://docs.aws.amazon.com/mediatailor/latest/ug/).
 *
 * Through the SDKs and the CLI you manage AWS Elemental MediaTailor configurations and channels the same as you do through the console. For example, you specify ad insertion behavior and mapping information for the origin server and the ad decision server (ADS).
 */
public interface MediaTailorClient : SdkClient {
    /**
     * MediaTailorClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, MediaTailorClient, Builder>()
     {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override fun finalizeConfig(builder: Builder) {
            super.finalizeConfig(builder)
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }

        override suspend fun finalizeEnvironmentalConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            super.finalizeEnvironmentalConfig(builder, sharedConfig, activeProfile)
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "MediaTailor",
                "MEDIATAILOR",
                "mediatailor",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, MediaTailorClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): MediaTailorClient = DefaultMediaTailorClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: MediaTailorEndpointProvider = builder.endpointProvider ?: DefaultMediaTailorEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: MediaTailorAuthSchemeProvider = builder.authSchemeProvider ?: DefaultMediaTailorAuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "MediaTailor"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: MediaTailorEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: MediaTailorAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Configures Amazon CloudWatch log settings for a channel.
     */
    public suspend fun configureLogsForChannel(input: ConfigureLogsForChannelRequest): ConfigureLogsForChannelResponse

    /**
     * Defines where AWS Elemental MediaTailor sends logs for the playback configuration.
     */
    public suspend fun configureLogsForPlaybackConfiguration(input: ConfigureLogsForPlaybackConfigurationRequest): ConfigureLogsForPlaybackConfigurationResponse

    /**
     * Creates a channel. For information about MediaTailor channels, see [Working with channels](https://docs.aws.amazon.com/mediatailor/latest/ug/channel-assembly-channels.html) in the *MediaTailor User Guide*.
     */
    public suspend fun createChannel(input: CreateChannelRequest): CreateChannelResponse

    /**
     * The live source configuration.
     */
    public suspend fun createLiveSource(input: CreateLiveSourceRequest): CreateLiveSourceResponse

    /**
     * Creates a prefetch schedule for a playback configuration. A prefetch schedule allows you to tell MediaTailor to fetch and prepare certain ads before an ad break happens. For more information about ad prefetching, see [Using ad prefetching](https://docs.aws.amazon.com/mediatailor/latest/ug/prefetching-ads.html) in the *MediaTailor User Guide*.
     */
    public suspend fun createPrefetchSchedule(input: CreatePrefetchScheduleRequest): CreatePrefetchScheduleResponse

    /**
     * Creates a program within a channel. For information about programs, see [Working with programs](https://docs.aws.amazon.com/mediatailor/latest/ug/channel-assembly-programs.html) in the *MediaTailor User Guide*.
     */
    public suspend fun createProgram(input: CreateProgramRequest): CreateProgramResponse

    /**
     * Creates a source location. A source location is a container for sources. For more information about source locations, see [Working with source locations](https://docs.aws.amazon.com/mediatailor/latest/ug/channel-assembly-source-locations.html) in the *MediaTailor User Guide*.
     */
    public suspend fun createSourceLocation(input: CreateSourceLocationRequest): CreateSourceLocationResponse

    /**
     * The VOD source configuration parameters.
     */
    public suspend fun createVodSource(input: CreateVodSourceRequest): CreateVodSourceResponse

    /**
     * Deletes a channel. For information about MediaTailor channels, see [Working with channels](https://docs.aws.amazon.com/mediatailor/latest/ug/channel-assembly-channels.html) in the *MediaTailor User Guide*.
     */
    public suspend fun deleteChannel(input: DeleteChannelRequest): DeleteChannelResponse

    /**
     * The channel policy to delete.
     */
    public suspend fun deleteChannelPolicy(input: DeleteChannelPolicyRequest): DeleteChannelPolicyResponse

    /**
     * The live source to delete.
     */
    public suspend fun deleteLiveSource(input: DeleteLiveSourceRequest): DeleteLiveSourceResponse

    /**
     * Deletes a playback configuration. For information about MediaTailor configurations, see [Working with configurations in AWS Elemental MediaTailor](https://docs.aws.amazon.com/mediatailor/latest/ug/configurations.html).
     */
    public suspend fun deletePlaybackConfiguration(input: DeletePlaybackConfigurationRequest): DeletePlaybackConfigurationResponse

    /**
     * Deletes a prefetch schedule for a specific playback configuration. If you call `DeletePrefetchSchedule` on an expired prefetch schedule, MediaTailor returns an HTTP 404 status code. For more information about ad prefetching, see [Using ad prefetching](https://docs.aws.amazon.com/mediatailor/latest/ug/prefetching-ads.html) in the *MediaTailor User Guide*.
     */
    public suspend fun deletePrefetchSchedule(input: DeletePrefetchScheduleRequest): DeletePrefetchScheduleResponse

    /**
     * Deletes a program within a channel. For information about programs, see [Working with programs](https://docs.aws.amazon.com/mediatailor/latest/ug/channel-assembly-programs.html) in the *MediaTailor User Guide*.
     */
    public suspend fun deleteProgram(input: DeleteProgramRequest): DeleteProgramResponse

    /**
     * Deletes a source location. A source location is a container for sources. For more information about source locations, see [Working with source locations](https://docs.aws.amazon.com/mediatailor/latest/ug/channel-assembly-source-locations.html) in the *MediaTailor User Guide*.
     */
    public suspend fun deleteSourceLocation(input: DeleteSourceLocationRequest): DeleteSourceLocationResponse

    /**
     * The video on demand (VOD) source to delete.
     */
    public suspend fun deleteVodSource(input: DeleteVodSourceRequest): DeleteVodSourceResponse

    /**
     * Describes a channel. For information about MediaTailor channels, see [Working with channels](https://docs.aws.amazon.com/mediatailor/latest/ug/channel-assembly-channels.html) in the *MediaTailor User Guide*.
     */
    public suspend fun describeChannel(input: DescribeChannelRequest): DescribeChannelResponse

    /**
     * The live source to describe.
     */
    public suspend fun describeLiveSource(input: DescribeLiveSourceRequest): DescribeLiveSourceResponse

    /**
     * Describes a program within a channel. For information about programs, see [Working with programs](https://docs.aws.amazon.com/mediatailor/latest/ug/channel-assembly-programs.html) in the *MediaTailor User Guide*.
     */
    public suspend fun describeProgram(input: DescribeProgramRequest): DescribeProgramResponse

    /**
     * Describes a source location. A source location is a container for sources. For more information about source locations, see [Working with source locations](https://docs.aws.amazon.com/mediatailor/latest/ug/channel-assembly-source-locations.html) in the *MediaTailor User Guide*.
     */
    public suspend fun describeSourceLocation(input: DescribeSourceLocationRequest): DescribeSourceLocationResponse

    /**
     * Provides details about a specific video on demand (VOD) source in a specific source location.
     */
    public suspend fun describeVodSource(input: DescribeVodSourceRequest): DescribeVodSourceResponse

    /**
     * Returns the channel's IAM policy. IAM policies are used to control access to your channel.
     */
    public suspend fun getChannelPolicy(input: GetChannelPolicyRequest): GetChannelPolicyResponse

    /**
     * Retrieves information about your channel's schedule.
     */
    public suspend fun getChannelSchedule(input: GetChannelScheduleRequest): GetChannelScheduleResponse

    /**
     * Retrieves a playback configuration. For information about MediaTailor configurations, see [Working with configurations in AWS Elemental MediaTailor](https://docs.aws.amazon.com/mediatailor/latest/ug/configurations.html).
     */
    public suspend fun getPlaybackConfiguration(input: GetPlaybackConfigurationRequest): GetPlaybackConfigurationResponse

    /**
     * Retrieves a prefetch schedule for a playback configuration. A prefetch schedule allows you to tell MediaTailor to fetch and prepare certain ads before an ad break happens. For more information about ad prefetching, see [Using ad prefetching](https://docs.aws.amazon.com/mediatailor/latest/ug/prefetching-ads.html) in the *MediaTailor User Guide*.
     */
    public suspend fun getPrefetchSchedule(input: GetPrefetchScheduleRequest): GetPrefetchScheduleResponse

    /**
     * Lists the alerts that are associated with a MediaTailor channel assembly resource.
     */
    public suspend fun listAlerts(input: ListAlertsRequest): ListAlertsResponse

    /**
     * Retrieves information about the channels that are associated with the current AWS account.
     */
    public suspend fun listChannels(input: ListChannelsRequest = ListChannelsRequest { }): ListChannelsResponse

    /**
     * Lists the live sources contained in a source location. A source represents a piece of content.
     */
    public suspend fun listLiveSources(input: ListLiveSourcesRequest): ListLiveSourcesResponse

    /**
     * Retrieves existing playback configurations. For information about MediaTailor configurations, see [Working with Configurations in AWS Elemental MediaTailor](https://docs.aws.amazon.com/mediatailor/latest/ug/configurations.html).
     */
    public suspend fun listPlaybackConfigurations(input: ListPlaybackConfigurationsRequest = ListPlaybackConfigurationsRequest { }): ListPlaybackConfigurationsResponse

    /**
     * Lists the prefetch schedules for a playback configuration.
     */
    public suspend fun listPrefetchSchedules(input: ListPrefetchSchedulesRequest): ListPrefetchSchedulesResponse

    /**
     * Lists the source locations for a channel. A source location defines the host server URL, and contains a list of sources.
     */
    public suspend fun listSourceLocations(input: ListSourceLocationsRequest = ListSourceLocationsRequest { }): ListSourceLocationsResponse

    /**
     * A list of tags that are associated with this resource. Tags are key-value pairs that you can associate with Amazon resources to help with organization, access control, and cost tracking. For more information, see [Tagging AWS Elemental MediaTailor Resources](https://docs.aws.amazon.com/mediatailor/latest/ug/tagging.html).
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Lists the VOD sources contained in a source location. A source represents a piece of content.
     */
    public suspend fun listVodSources(input: ListVodSourcesRequest): ListVodSourcesResponse

    /**
     * Creates an IAM policy for the channel. IAM policies are used to control access to your channel.
     */
    public suspend fun putChannelPolicy(input: PutChannelPolicyRequest): PutChannelPolicyResponse

    /**
     * Creates a playback configuration. For information about MediaTailor configurations, see [Working with configurations in AWS Elemental MediaTailor](https://docs.aws.amazon.com/mediatailor/latest/ug/configurations.html).
     */
    public suspend fun putPlaybackConfiguration(input: PutPlaybackConfigurationRequest): PutPlaybackConfigurationResponse

    /**
     * Starts a channel. For information about MediaTailor channels, see [Working with channels](https://docs.aws.amazon.com/mediatailor/latest/ug/channel-assembly-channels.html) in the *MediaTailor User Guide*.
     */
    public suspend fun startChannel(input: StartChannelRequest): StartChannelResponse

    /**
     * Stops a channel. For information about MediaTailor channels, see [Working with channels](https://docs.aws.amazon.com/mediatailor/latest/ug/channel-assembly-channels.html) in the *MediaTailor User Guide*.
     */
    public suspend fun stopChannel(input: StopChannelRequest): StopChannelResponse

    /**
     * The resource to tag. Tags are key-value pairs that you can associate with Amazon resources to help with organization, access control, and cost tracking. For more information, see [Tagging AWS Elemental MediaTailor Resources](https://docs.aws.amazon.com/mediatailor/latest/ug/tagging.html).
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * The resource to untag.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates a channel. For information about MediaTailor channels, see [Working with channels](https://docs.aws.amazon.com/mediatailor/latest/ug/channel-assembly-channels.html) in the *MediaTailor User Guide*.
     */
    public suspend fun updateChannel(input: UpdateChannelRequest): UpdateChannelResponse

    /**
     * Updates a live source's configuration.
     */
    public suspend fun updateLiveSource(input: UpdateLiveSourceRequest): UpdateLiveSourceResponse

    /**
     * Updates a program within a channel.
     */
    public suspend fun updateProgram(input: UpdateProgramRequest): UpdateProgramResponse

    /**
     * Updates a source location. A source location is a container for sources. For more information about source locations, see [Working with source locations](https://docs.aws.amazon.com/mediatailor/latest/ug/channel-assembly-source-locations.html) in the *MediaTailor User Guide*.
     */
    public suspend fun updateSourceLocation(input: UpdateSourceLocationRequest): UpdateSourceLocationResponse

    /**
     * Updates a VOD source's configuration.
     */
    public suspend fun updateVodSource(input: UpdateVodSourceRequest): UpdateVodSourceResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun MediaTailorClient.withConfig(block: MediaTailorClient.Config.Builder.() -> Unit): MediaTailorClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultMediaTailorClient(newConfig)
}

/**
 * Configures Amazon CloudWatch log settings for a channel.
 */
public suspend inline fun MediaTailorClient.configureLogsForChannel(crossinline block: ConfigureLogsForChannelRequest.Builder.() -> Unit): ConfigureLogsForChannelResponse = configureLogsForChannel(ConfigureLogsForChannelRequest.Builder().apply(block).build())

/**
 * Defines where AWS Elemental MediaTailor sends logs for the playback configuration.
 */
public suspend inline fun MediaTailorClient.configureLogsForPlaybackConfiguration(crossinline block: ConfigureLogsForPlaybackConfigurationRequest.Builder.() -> Unit): ConfigureLogsForPlaybackConfigurationResponse = configureLogsForPlaybackConfiguration(ConfigureLogsForPlaybackConfigurationRequest.Builder().apply(block).build())

/**
 * Creates a channel. For information about MediaTailor channels, see [Working with channels](https://docs.aws.amazon.com/mediatailor/latest/ug/channel-assembly-channels.html) in the *MediaTailor User Guide*.
 */
public suspend inline fun MediaTailorClient.createChannel(crossinline block: CreateChannelRequest.Builder.() -> Unit): CreateChannelResponse = createChannel(CreateChannelRequest.Builder().apply(block).build())

/**
 * The live source configuration.
 */
public suspend inline fun MediaTailorClient.createLiveSource(crossinline block: CreateLiveSourceRequest.Builder.() -> Unit): CreateLiveSourceResponse = createLiveSource(CreateLiveSourceRequest.Builder().apply(block).build())

/**
 * Creates a prefetch schedule for a playback configuration. A prefetch schedule allows you to tell MediaTailor to fetch and prepare certain ads before an ad break happens. For more information about ad prefetching, see [Using ad prefetching](https://docs.aws.amazon.com/mediatailor/latest/ug/prefetching-ads.html) in the *MediaTailor User Guide*.
 */
public suspend inline fun MediaTailorClient.createPrefetchSchedule(crossinline block: CreatePrefetchScheduleRequest.Builder.() -> Unit): CreatePrefetchScheduleResponse = createPrefetchSchedule(CreatePrefetchScheduleRequest.Builder().apply(block).build())

/**
 * Creates a program within a channel. For information about programs, see [Working with programs](https://docs.aws.amazon.com/mediatailor/latest/ug/channel-assembly-programs.html) in the *MediaTailor User Guide*.
 */
public suspend inline fun MediaTailorClient.createProgram(crossinline block: CreateProgramRequest.Builder.() -> Unit): CreateProgramResponse = createProgram(CreateProgramRequest.Builder().apply(block).build())

/**
 * Creates a source location. A source location is a container for sources. For more information about source locations, see [Working with source locations](https://docs.aws.amazon.com/mediatailor/latest/ug/channel-assembly-source-locations.html) in the *MediaTailor User Guide*.
 */
public suspend inline fun MediaTailorClient.createSourceLocation(crossinline block: CreateSourceLocationRequest.Builder.() -> Unit): CreateSourceLocationResponse = createSourceLocation(CreateSourceLocationRequest.Builder().apply(block).build())

/**
 * The VOD source configuration parameters.
 */
public suspend inline fun MediaTailorClient.createVodSource(crossinline block: CreateVodSourceRequest.Builder.() -> Unit): CreateVodSourceResponse = createVodSource(CreateVodSourceRequest.Builder().apply(block).build())

/**
 * Deletes a channel. For information about MediaTailor channels, see [Working with channels](https://docs.aws.amazon.com/mediatailor/latest/ug/channel-assembly-channels.html) in the *MediaTailor User Guide*.
 */
public suspend inline fun MediaTailorClient.deleteChannel(crossinline block: DeleteChannelRequest.Builder.() -> Unit): DeleteChannelResponse = deleteChannel(DeleteChannelRequest.Builder().apply(block).build())

/**
 * The channel policy to delete.
 */
public suspend inline fun MediaTailorClient.deleteChannelPolicy(crossinline block: DeleteChannelPolicyRequest.Builder.() -> Unit): DeleteChannelPolicyResponse = deleteChannelPolicy(DeleteChannelPolicyRequest.Builder().apply(block).build())

/**
 * The live source to delete.
 */
public suspend inline fun MediaTailorClient.deleteLiveSource(crossinline block: DeleteLiveSourceRequest.Builder.() -> Unit): DeleteLiveSourceResponse = deleteLiveSource(DeleteLiveSourceRequest.Builder().apply(block).build())

/**
 * Deletes a playback configuration. For information about MediaTailor configurations, see [Working with configurations in AWS Elemental MediaTailor](https://docs.aws.amazon.com/mediatailor/latest/ug/configurations.html).
 */
public suspend inline fun MediaTailorClient.deletePlaybackConfiguration(crossinline block: DeletePlaybackConfigurationRequest.Builder.() -> Unit): DeletePlaybackConfigurationResponse = deletePlaybackConfiguration(DeletePlaybackConfigurationRequest.Builder().apply(block).build())

/**
 * Deletes a prefetch schedule for a specific playback configuration. If you call `DeletePrefetchSchedule` on an expired prefetch schedule, MediaTailor returns an HTTP 404 status code. For more information about ad prefetching, see [Using ad prefetching](https://docs.aws.amazon.com/mediatailor/latest/ug/prefetching-ads.html) in the *MediaTailor User Guide*.
 */
public suspend inline fun MediaTailorClient.deletePrefetchSchedule(crossinline block: DeletePrefetchScheduleRequest.Builder.() -> Unit): DeletePrefetchScheduleResponse = deletePrefetchSchedule(DeletePrefetchScheduleRequest.Builder().apply(block).build())

/**
 * Deletes a program within a channel. For information about programs, see [Working with programs](https://docs.aws.amazon.com/mediatailor/latest/ug/channel-assembly-programs.html) in the *MediaTailor User Guide*.
 */
public suspend inline fun MediaTailorClient.deleteProgram(crossinline block: DeleteProgramRequest.Builder.() -> Unit): DeleteProgramResponse = deleteProgram(DeleteProgramRequest.Builder().apply(block).build())

/**
 * Deletes a source location. A source location is a container for sources. For more information about source locations, see [Working with source locations](https://docs.aws.amazon.com/mediatailor/latest/ug/channel-assembly-source-locations.html) in the *MediaTailor User Guide*.
 */
public suspend inline fun MediaTailorClient.deleteSourceLocation(crossinline block: DeleteSourceLocationRequest.Builder.() -> Unit): DeleteSourceLocationResponse = deleteSourceLocation(DeleteSourceLocationRequest.Builder().apply(block).build())

/**
 * The video on demand (VOD) source to delete.
 */
public suspend inline fun MediaTailorClient.deleteVodSource(crossinline block: DeleteVodSourceRequest.Builder.() -> Unit): DeleteVodSourceResponse = deleteVodSource(DeleteVodSourceRequest.Builder().apply(block).build())

/**
 * Describes a channel. For information about MediaTailor channels, see [Working with channels](https://docs.aws.amazon.com/mediatailor/latest/ug/channel-assembly-channels.html) in the *MediaTailor User Guide*.
 */
public suspend inline fun MediaTailorClient.describeChannel(crossinline block: DescribeChannelRequest.Builder.() -> Unit): DescribeChannelResponse = describeChannel(DescribeChannelRequest.Builder().apply(block).build())

/**
 * The live source to describe.
 */
public suspend inline fun MediaTailorClient.describeLiveSource(crossinline block: DescribeLiveSourceRequest.Builder.() -> Unit): DescribeLiveSourceResponse = describeLiveSource(DescribeLiveSourceRequest.Builder().apply(block).build())

/**
 * Describes a program within a channel. For information about programs, see [Working with programs](https://docs.aws.amazon.com/mediatailor/latest/ug/channel-assembly-programs.html) in the *MediaTailor User Guide*.
 */
public suspend inline fun MediaTailorClient.describeProgram(crossinline block: DescribeProgramRequest.Builder.() -> Unit): DescribeProgramResponse = describeProgram(DescribeProgramRequest.Builder().apply(block).build())

/**
 * Describes a source location. A source location is a container for sources. For more information about source locations, see [Working with source locations](https://docs.aws.amazon.com/mediatailor/latest/ug/channel-assembly-source-locations.html) in the *MediaTailor User Guide*.
 */
public suspend inline fun MediaTailorClient.describeSourceLocation(crossinline block: DescribeSourceLocationRequest.Builder.() -> Unit): DescribeSourceLocationResponse = describeSourceLocation(DescribeSourceLocationRequest.Builder().apply(block).build())

/**
 * Provides details about a specific video on demand (VOD) source in a specific source location.
 */
public suspend inline fun MediaTailorClient.describeVodSource(crossinline block: DescribeVodSourceRequest.Builder.() -> Unit): DescribeVodSourceResponse = describeVodSource(DescribeVodSourceRequest.Builder().apply(block).build())

/**
 * Returns the channel's IAM policy. IAM policies are used to control access to your channel.
 */
public suspend inline fun MediaTailorClient.getChannelPolicy(crossinline block: GetChannelPolicyRequest.Builder.() -> Unit): GetChannelPolicyResponse = getChannelPolicy(GetChannelPolicyRequest.Builder().apply(block).build())

/**
 * Retrieves information about your channel's schedule.
 */
public suspend inline fun MediaTailorClient.getChannelSchedule(crossinline block: GetChannelScheduleRequest.Builder.() -> Unit): GetChannelScheduleResponse = getChannelSchedule(GetChannelScheduleRequest.Builder().apply(block).build())

/**
 * Retrieves a playback configuration. For information about MediaTailor configurations, see [Working with configurations in AWS Elemental MediaTailor](https://docs.aws.amazon.com/mediatailor/latest/ug/configurations.html).
 */
public suspend inline fun MediaTailorClient.getPlaybackConfiguration(crossinline block: GetPlaybackConfigurationRequest.Builder.() -> Unit): GetPlaybackConfigurationResponse = getPlaybackConfiguration(GetPlaybackConfigurationRequest.Builder().apply(block).build())

/**
 * Retrieves a prefetch schedule for a playback configuration. A prefetch schedule allows you to tell MediaTailor to fetch and prepare certain ads before an ad break happens. For more information about ad prefetching, see [Using ad prefetching](https://docs.aws.amazon.com/mediatailor/latest/ug/prefetching-ads.html) in the *MediaTailor User Guide*.
 */
public suspend inline fun MediaTailorClient.getPrefetchSchedule(crossinline block: GetPrefetchScheduleRequest.Builder.() -> Unit): GetPrefetchScheduleResponse = getPrefetchSchedule(GetPrefetchScheduleRequest.Builder().apply(block).build())

/**
 * Lists the alerts that are associated with a MediaTailor channel assembly resource.
 */
public suspend inline fun MediaTailorClient.listAlerts(crossinline block: ListAlertsRequest.Builder.() -> Unit): ListAlertsResponse = listAlerts(ListAlertsRequest.Builder().apply(block).build())

/**
 * Retrieves information about the channels that are associated with the current AWS account.
 */
public suspend inline fun MediaTailorClient.listChannels(crossinline block: ListChannelsRequest.Builder.() -> Unit): ListChannelsResponse = listChannels(ListChannelsRequest.Builder().apply(block).build())

/**
 * Lists the live sources contained in a source location. A source represents a piece of content.
 */
public suspend inline fun MediaTailorClient.listLiveSources(crossinline block: ListLiveSourcesRequest.Builder.() -> Unit): ListLiveSourcesResponse = listLiveSources(ListLiveSourcesRequest.Builder().apply(block).build())

/**
 * Retrieves existing playback configurations. For information about MediaTailor configurations, see [Working with Configurations in AWS Elemental MediaTailor](https://docs.aws.amazon.com/mediatailor/latest/ug/configurations.html).
 */
public suspend inline fun MediaTailorClient.listPlaybackConfigurations(crossinline block: ListPlaybackConfigurationsRequest.Builder.() -> Unit): ListPlaybackConfigurationsResponse = listPlaybackConfigurations(ListPlaybackConfigurationsRequest.Builder().apply(block).build())

/**
 * Lists the prefetch schedules for a playback configuration.
 */
public suspend inline fun MediaTailorClient.listPrefetchSchedules(crossinline block: ListPrefetchSchedulesRequest.Builder.() -> Unit): ListPrefetchSchedulesResponse = listPrefetchSchedules(ListPrefetchSchedulesRequest.Builder().apply(block).build())

/**
 * Lists the source locations for a channel. A source location defines the host server URL, and contains a list of sources.
 */
public suspend inline fun MediaTailorClient.listSourceLocations(crossinline block: ListSourceLocationsRequest.Builder.() -> Unit): ListSourceLocationsResponse = listSourceLocations(ListSourceLocationsRequest.Builder().apply(block).build())

/**
 * A list of tags that are associated with this resource. Tags are key-value pairs that you can associate with Amazon resources to help with organization, access control, and cost tracking. For more information, see [Tagging AWS Elemental MediaTailor Resources](https://docs.aws.amazon.com/mediatailor/latest/ug/tagging.html).
 */
public suspend inline fun MediaTailorClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Lists the VOD sources contained in a source location. A source represents a piece of content.
 */
public suspend inline fun MediaTailorClient.listVodSources(crossinline block: ListVodSourcesRequest.Builder.() -> Unit): ListVodSourcesResponse = listVodSources(ListVodSourcesRequest.Builder().apply(block).build())

/**
 * Creates an IAM policy for the channel. IAM policies are used to control access to your channel.
 */
public suspend inline fun MediaTailorClient.putChannelPolicy(crossinline block: PutChannelPolicyRequest.Builder.() -> Unit): PutChannelPolicyResponse = putChannelPolicy(PutChannelPolicyRequest.Builder().apply(block).build())

/**
 * Creates a playback configuration. For information about MediaTailor configurations, see [Working with configurations in AWS Elemental MediaTailor](https://docs.aws.amazon.com/mediatailor/latest/ug/configurations.html).
 */
public suspend inline fun MediaTailorClient.putPlaybackConfiguration(crossinline block: PutPlaybackConfigurationRequest.Builder.() -> Unit): PutPlaybackConfigurationResponse = putPlaybackConfiguration(PutPlaybackConfigurationRequest.Builder().apply(block).build())

/**
 * Starts a channel. For information about MediaTailor channels, see [Working with channels](https://docs.aws.amazon.com/mediatailor/latest/ug/channel-assembly-channels.html) in the *MediaTailor User Guide*.
 */
public suspend inline fun MediaTailorClient.startChannel(crossinline block: StartChannelRequest.Builder.() -> Unit): StartChannelResponse = startChannel(StartChannelRequest.Builder().apply(block).build())

/**
 * Stops a channel. For information about MediaTailor channels, see [Working with channels](https://docs.aws.amazon.com/mediatailor/latest/ug/channel-assembly-channels.html) in the *MediaTailor User Guide*.
 */
public suspend inline fun MediaTailorClient.stopChannel(crossinline block: StopChannelRequest.Builder.() -> Unit): StopChannelResponse = stopChannel(StopChannelRequest.Builder().apply(block).build())

/**
 * The resource to tag. Tags are key-value pairs that you can associate with Amazon resources to help with organization, access control, and cost tracking. For more information, see [Tagging AWS Elemental MediaTailor Resources](https://docs.aws.amazon.com/mediatailor/latest/ug/tagging.html).
 */
public suspend inline fun MediaTailorClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * The resource to untag.
 */
public suspend inline fun MediaTailorClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates a channel. For information about MediaTailor channels, see [Working with channels](https://docs.aws.amazon.com/mediatailor/latest/ug/channel-assembly-channels.html) in the *MediaTailor User Guide*.
 */
public suspend inline fun MediaTailorClient.updateChannel(crossinline block: UpdateChannelRequest.Builder.() -> Unit): UpdateChannelResponse = updateChannel(UpdateChannelRequest.Builder().apply(block).build())

/**
 * Updates a live source's configuration.
 */
public suspend inline fun MediaTailorClient.updateLiveSource(crossinline block: UpdateLiveSourceRequest.Builder.() -> Unit): UpdateLiveSourceResponse = updateLiveSource(UpdateLiveSourceRequest.Builder().apply(block).build())

/**
 * Updates a program within a channel.
 */
public suspend inline fun MediaTailorClient.updateProgram(crossinline block: UpdateProgramRequest.Builder.() -> Unit): UpdateProgramResponse = updateProgram(UpdateProgramRequest.Builder().apply(block).build())

/**
 * Updates a source location. A source location is a container for sources. For more information about source locations, see [Working with source locations](https://docs.aws.amazon.com/mediatailor/latest/ug/channel-assembly-source-locations.html) in the *MediaTailor User Guide*.
 */
public suspend inline fun MediaTailorClient.updateSourceLocation(crossinline block: UpdateSourceLocationRequest.Builder.() -> Unit): UpdateSourceLocationResponse = updateSourceLocation(UpdateSourceLocationRequest.Builder().apply(block).build())

/**
 * Updates a VOD source's configuration.
 */
public suspend inline fun MediaTailorClient.updateVodSource(crossinline block: UpdateVodSourceRequest.Builder.() -> Unit): UpdateVodSourceResponse = updateVodSource(UpdateVodSourceRequest.Builder().apply(block).build())
