// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediatailor.serde

import aws.sdk.kotlin.services.mediatailor.model.GetPrefetchScheduleResponse
import aws.sdk.kotlin.services.mediatailor.model.MediaTailorException
import aws.sdk.kotlin.services.mediatailor.model.PrefetchConsumption
import aws.sdk.kotlin.services.mediatailor.model.PrefetchRetrieval
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetPrefetchScheduleOperationDeserializer: HttpDeserializer.NonStreaming<GetPrefetchScheduleResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetPrefetchScheduleResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetPrefetchScheduleError(context, call, payload)
        }
        val builder = GetPrefetchScheduleResponse.Builder()

        if (payload != null) {
            deserializeGetPrefetchScheduleOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetPrefetchScheduleError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw MediaTailorException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        else -> MediaTailorException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetPrefetchScheduleOperationBody(builder: GetPrefetchScheduleResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Arn"))
    val CONSUMPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Consumption"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Name"))
    val PLAYBACKCONFIGURATIONNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("PlaybackConfigurationName"))
    val RETRIEVAL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Retrieval"))
    val STREAMID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("StreamId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ARN_DESCRIPTOR)
        field(CONSUMPTION_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(PLAYBACKCONFIGURATIONNAME_DESCRIPTOR)
        field(RETRIEVAL_DESCRIPTOR)
        field(STREAMID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ARN_DESCRIPTOR.index -> builder.arn = deserializeString()
                CONSUMPTION_DESCRIPTOR.index -> builder.consumption = deserializePrefetchConsumptionDocument(deserializer)
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                PLAYBACKCONFIGURATIONNAME_DESCRIPTOR.index -> builder.playbackConfigurationName = deserializeString()
                RETRIEVAL_DESCRIPTOR.index -> builder.retrieval = deserializePrefetchRetrievalDocument(deserializer)
                STREAMID_DESCRIPTOR.index -> builder.streamId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
