// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediatailor.serde

import aws.sdk.kotlin.services.mediatailor.model.CreateChannelRequest
import aws.sdk.kotlin.services.mediatailor.model.PlaybackMode
import aws.sdk.kotlin.services.mediatailor.model.RequestOutputItem
import aws.sdk.kotlin.services.mediatailor.model.SlateSource
import aws.sdk.kotlin.services.mediatailor.model.Tier
import aws.sdk.kotlin.services.mediatailor.model.TimeShiftConfiguration
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class CreateChannelOperationSerializer: HttpSerializer.NonStreaming<CreateChannelRequest> {
    override fun serialize(context: ExecutionContext, input: CreateChannelRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path.encodedSegments {
                add(PercentEncoding.Path.encode("channel"))
                add(PercentEncoding.SmithyLabel.encode(input.channelName))
            }
        }

        val payload = serializeCreateChannelOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCreateChannelOperationBody(context: ExecutionContext, input: CreateChannelRequest): ByteArray {
    val serializer = JsonSerializer()
    val AUDIENCES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Audiences"))
    val FILLERSLATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("FillerSlate"))
    val OUTPUTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Outputs"))
    val PLAYBACKMODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("PlaybackMode"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("tags"))
    val TIER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("Tier"))
    val TIMESHIFTCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("TimeShiftConfiguration"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(AUDIENCES_DESCRIPTOR)
        field(FILLERSLATE_DESCRIPTOR)
        field(OUTPUTS_DESCRIPTOR)
        field(PLAYBACKMODE_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(TIER_DESCRIPTOR)
        field(TIMESHIFTCONFIGURATION_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        if (input.audiences != null) {
            listField(AUDIENCES_DESCRIPTOR) {
                for (el0 in input.audiences) {
                    serializeString(el0)
                }
            }
        }
        input.fillerSlate?.let { field(FILLERSLATE_DESCRIPTOR, it, ::serializeSlateSourceDocument) }
        listField(OUTPUTS_DESCRIPTOR) {
            for (el0 in input.outputs) {
                serializeSdkSerializable(asSdkSerializable(el0, ::serializeRequestOutputItemDocument))
            }
        }
        field(PLAYBACKMODE_DESCRIPTOR, input.playbackMode.value)
        if (input.tags != null) {
            mapField(TAGS_DESCRIPTOR) {
                input.tags.forEach { (key, value) ->
                    entry(key, value)
                }
            }
        }
        input.tier?.let { field(TIER_DESCRIPTOR, it.value) }
        input.timeShiftConfiguration?.let { field(TIMESHIFTCONFIGURATION_DESCRIPTOR, it, ::serializeTimeShiftConfigurationDocument) }
    }
    return serializer.toByteArray()
}
