// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediatailor.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * A complex type that contains settings governing when MediaTailor prefetches ads, and which dynamic variables that MediaTailor includes in the request to the ad decision server.
 */
public class PrefetchRetrieval private constructor(builder: Builder) {
    /**
     * The dynamic variables to use for substitution during prefetch requests to the ad decision server (ADS).
     *
     * You initially configure [dynamic variables](https://docs.aws.amazon.com/mediatailor/latest/ug/variables.html) for the ADS URL when you set up your playback configuration. When you specify `DynamicVariables` for prefetch retrieval, MediaTailor includes the dynamic variables in the request to the ADS.
     */
    public val dynamicVariables: Map<String, String>? = builder.dynamicVariables
    /**
     * The time when prefetch retrieval ends for the ad break. Prefetching will be attempted for manifest requests that occur at or before this time.
     */
    public val endTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.endTime) { "A non-null value must be provided for endTime" }
    /**
     * The time when prefetch retrievals can start for this break. Ad prefetching will be attempted for manifest requests that occur at or after this time. Defaults to the current time. If not specified, the prefetch retrieval starts as soon as possible.
     */
    public val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediatailor.model.PrefetchRetrieval = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PrefetchRetrieval(")
        append("dynamicVariables=$dynamicVariables,")
        append("endTime=$endTime,")
        append("startTime=$startTime")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dynamicVariables?.hashCode() ?: 0
        result = 31 * result + (endTime.hashCode())
        result = 31 * result + (startTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PrefetchRetrieval

        if (dynamicVariables != other.dynamicVariables) return false
        if (endTime != other.endTime) return false
        if (startTime != other.startTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediatailor.model.PrefetchRetrieval = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The dynamic variables to use for substitution during prefetch requests to the ad decision server (ADS).
         *
         * You initially configure [dynamic variables](https://docs.aws.amazon.com/mediatailor/latest/ug/variables.html) for the ADS URL when you set up your playback configuration. When you specify `DynamicVariables` for prefetch retrieval, MediaTailor includes the dynamic variables in the request to the ADS.
         */
        public var dynamicVariables: Map<String, String>? = null
        /**
         * The time when prefetch retrieval ends for the ad break. Prefetching will be attempted for manifest requests that occur at or before this time.
         */
        public var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The time when prefetch retrievals can start for this break. Ad prefetching will be attempted for manifest requests that occur at or after this time. Defaults to the current time. If not specified, the prefetch retrieval starts as soon as possible.
         */
        public var startTime: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediatailor.model.PrefetchRetrieval) : this() {
            this.dynamicVariables = x.dynamicVariables
            this.endTime = x.endTime
            this.startTime = x.startTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediatailor.model.PrefetchRetrieval = PrefetchRetrieval(this)

        internal fun correctErrors(): Builder {
            if (endTime == null) endTime = Instant.fromEpochSeconds(0)
            return this
        }
    }
}
