// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediatailor.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class DescribeChannelResponse private constructor(builder: Builder) {
    /**
     * The ARN of the channel.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The list of audiences defined in channel.
     */
    public val audiences: List<String>? = builder.audiences
    /**
     * The name of the channel.
     */
    public val channelName: kotlin.String? = builder.channelName
    /**
     * Indicates whether the channel is in a running state or not.
     */
    public val channelState: aws.sdk.kotlin.services.mediatailor.model.ChannelState? = builder.channelState
    /**
     * The timestamp of when the channel was created.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * Contains information about the slate used to fill gaps between programs in the schedule.
     */
    public val fillerSlate: aws.sdk.kotlin.services.mediatailor.model.SlateSource? = builder.fillerSlate
    /**
     * The timestamp of when the channel was last modified.
     */
    public val lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedTime
    /**
     * The log configuration for the channel.
     */
    public val logConfiguration: aws.sdk.kotlin.services.mediatailor.model.LogConfigurationForChannel? = builder.logConfiguration
    /**
     * The channel's output properties.
     */
    public val outputs: List<ResponseOutputItem>? = builder.outputs
    /**
     * The channel's playback mode.
     */
    public val playbackMode: kotlin.String? = builder.playbackMode
    /**
     * The tags assigned to the channel. Tags are key-value pairs that you can associate with Amazon resources to help with organization, access control, and cost tracking. For more information, see [Tagging AWS Elemental MediaTailor Resources](https://docs.aws.amazon.com/mediatailor/latest/ug/tagging.html).
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The channel's tier.
     */
    public val tier: kotlin.String? = builder.tier
    /**
     * The time-shifted viewing configuration for the channel.
     */
    public val timeShiftConfiguration: aws.sdk.kotlin.services.mediatailor.model.TimeShiftConfiguration? = builder.timeShiftConfiguration

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediatailor.model.DescribeChannelResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeChannelResponse(")
        append("arn=$arn,")
        append("audiences=$audiences,")
        append("channelName=$channelName,")
        append("channelState=$channelState,")
        append("creationTime=$creationTime,")
        append("fillerSlate=$fillerSlate,")
        append("lastModifiedTime=$lastModifiedTime,")
        append("logConfiguration=$logConfiguration,")
        append("outputs=$outputs,")
        append("playbackMode=$playbackMode,")
        append("tags=$tags,")
        append("tier=$tier,")
        append("timeShiftConfiguration=$timeShiftConfiguration")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (audiences?.hashCode() ?: 0)
        result = 31 * result + (channelName?.hashCode() ?: 0)
        result = 31 * result + (channelState?.hashCode() ?: 0)
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (fillerSlate?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedTime?.hashCode() ?: 0)
        result = 31 * result + (logConfiguration?.hashCode() ?: 0)
        result = 31 * result + (outputs?.hashCode() ?: 0)
        result = 31 * result + (playbackMode?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (tier?.hashCode() ?: 0)
        result = 31 * result + (timeShiftConfiguration?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeChannelResponse

        if (arn != other.arn) return false
        if (audiences != other.audiences) return false
        if (channelName != other.channelName) return false
        if (channelState != other.channelState) return false
        if (creationTime != other.creationTime) return false
        if (fillerSlate != other.fillerSlate) return false
        if (lastModifiedTime != other.lastModifiedTime) return false
        if (logConfiguration != other.logConfiguration) return false
        if (outputs != other.outputs) return false
        if (playbackMode != other.playbackMode) return false
        if (tags != other.tags) return false
        if (tier != other.tier) return false
        if (timeShiftConfiguration != other.timeShiftConfiguration) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediatailor.model.DescribeChannelResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ARN of the channel.
         */
        public var arn: kotlin.String? = null
        /**
         * The list of audiences defined in channel.
         */
        public var audiences: List<String>? = null
        /**
         * The name of the channel.
         */
        public var channelName: kotlin.String? = null
        /**
         * Indicates whether the channel is in a running state or not.
         */
        public var channelState: aws.sdk.kotlin.services.mediatailor.model.ChannelState? = null
        /**
         * The timestamp of when the channel was created.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Contains information about the slate used to fill gaps between programs in the schedule.
         */
        public var fillerSlate: aws.sdk.kotlin.services.mediatailor.model.SlateSource? = null
        /**
         * The timestamp of when the channel was last modified.
         */
        public var lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The log configuration for the channel.
         */
        public var logConfiguration: aws.sdk.kotlin.services.mediatailor.model.LogConfigurationForChannel? = null
        /**
         * The channel's output properties.
         */
        public var outputs: List<ResponseOutputItem>? = null
        /**
         * The channel's playback mode.
         */
        public var playbackMode: kotlin.String? = null
        /**
         * The tags assigned to the channel. Tags are key-value pairs that you can associate with Amazon resources to help with organization, access control, and cost tracking. For more information, see [Tagging AWS Elemental MediaTailor Resources](https://docs.aws.amazon.com/mediatailor/latest/ug/tagging.html).
         */
        public var tags: Map<String, String>? = null
        /**
         * The channel's tier.
         */
        public var tier: kotlin.String? = null
        /**
         * The time-shifted viewing configuration for the channel.
         */
        public var timeShiftConfiguration: aws.sdk.kotlin.services.mediatailor.model.TimeShiftConfiguration? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediatailor.model.DescribeChannelResponse) : this() {
            this.arn = x.arn
            this.audiences = x.audiences
            this.channelName = x.channelName
            this.channelState = x.channelState
            this.creationTime = x.creationTime
            this.fillerSlate = x.fillerSlate
            this.lastModifiedTime = x.lastModifiedTime
            this.logConfiguration = x.logConfiguration
            this.outputs = x.outputs
            this.playbackMode = x.playbackMode
            this.tags = x.tags
            this.tier = x.tier
            this.timeShiftConfiguration = x.timeShiftConfiguration
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediatailor.model.DescribeChannelResponse = DescribeChannelResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.mediatailor.model.SlateSource] inside the given [block]
         */
        public fun fillerSlate(block: aws.sdk.kotlin.services.mediatailor.model.SlateSource.Builder.() -> kotlin.Unit) {
            this.fillerSlate = aws.sdk.kotlin.services.mediatailor.model.SlateSource.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediatailor.model.LogConfigurationForChannel] inside the given [block]
         */
        public fun logConfiguration(block: aws.sdk.kotlin.services.mediatailor.model.LogConfigurationForChannel.Builder.() -> kotlin.Unit) {
            this.logConfiguration = aws.sdk.kotlin.services.mediatailor.model.LogConfigurationForChannel.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediatailor.model.TimeShiftConfiguration] inside the given [block]
         */
        public fun timeShiftConfiguration(block: aws.sdk.kotlin.services.mediatailor.model.TimeShiftConfiguration.Builder.() -> kotlin.Unit) {
            this.timeShiftConfiguration = aws.sdk.kotlin.services.mediatailor.model.TimeShiftConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
