// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediatailor.serde

import aws.sdk.kotlin.services.mediatailor.model.AdBreak
import aws.sdk.kotlin.services.mediatailor.model.AudienceMedia
import aws.sdk.kotlin.services.mediatailor.model.UpdateProgramRequest
import aws.sdk.kotlin.services.mediatailor.model.UpdateProgramScheduleConfiguration
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class UpdateProgramOperationSerializer: HttpSerializer.NonStreaming<UpdateProgramRequest> {
    override fun serialize(context: ExecutionContext, input: UpdateProgramRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            path.encodedSegments {
                add(PercentEncoding.Path.encode("channel"))
                add(PercentEncoding.SmithyLabel.encode(input.channelName))
                add(PercentEncoding.Path.encode("program"))
                add(PercentEncoding.SmithyLabel.encode(input.programName))
            }
        }

        val payload = serializeUpdateProgramOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateProgramOperationBody(context: ExecutionContext, input: UpdateProgramRequest): ByteArray {
    val serializer = JsonSerializer()
    val ADBREAKS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("AdBreaks"))
    val AUDIENCEMEDIA_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("AudienceMedia"))
    val SCHEDULECONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ScheduleConfiguration"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ADBREAKS_DESCRIPTOR)
        field(AUDIENCEMEDIA_DESCRIPTOR)
        field(SCHEDULECONFIGURATION_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        if (input.adBreaks != null) {
            listField(ADBREAKS_DESCRIPTOR) {
                for (el0 in input.adBreaks) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeAdBreakDocument))
                }
            }
        }
        if (input.audienceMedia != null) {
            listField(AUDIENCEMEDIA_DESCRIPTOR) {
                for (el0 in input.audienceMedia) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeAudienceMediaDocument))
                }
            }
        }
        input.scheduleConfiguration?.let { field(SCHEDULECONFIGURATION_DESCRIPTOR, it, ::serializeUpdateProgramScheduleConfigurationDocument) }
    }
    return serializer.toByteArray()
}
