// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediatailor.serde

import aws.sdk.kotlin.services.mediatailor.model.AdBreakOpportunity
import aws.sdk.kotlin.services.mediatailor.model.DescribeVodSourceResponse
import aws.sdk.kotlin.services.mediatailor.model.HttpPackageConfiguration
import aws.sdk.kotlin.services.mediatailor.model.MediaTailorException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import kotlin.collections.mutableListOf
import kotlin.collections.mutableMapOf


internal class DescribeVodSourceOperationDeserializer: HttpDeserializer.NonStreaming<DescribeVodSourceResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeVodSourceResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeVodSourceError(context, call, payload)
        }
        val builder = DescribeVodSourceResponse.Builder()

        if (payload != null) {
            deserializeDescribeVodSourceOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeVodSourceError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw MediaTailorException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        else -> MediaTailorException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeVodSourceOperationBody(builder: DescribeVodSourceResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ADBREAKOPPORTUNITIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("AdBreakOpportunities"))
    val ARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Arn"))
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreationTime"))
    val HTTPPACKAGECONFIGURATIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("HttpPackageConfigurations"))
    val LASTMODIFIEDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LastModifiedTime"))
    val SOURCELOCATIONNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SourceLocationName"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("tags"))
    val VODSOURCENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("VodSourceName"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ADBREAKOPPORTUNITIES_DESCRIPTOR)
        field(ARN_DESCRIPTOR)
        field(CREATIONTIME_DESCRIPTOR)
        field(HTTPPACKAGECONFIGURATIONS_DESCRIPTOR)
        field(LASTMODIFIEDTIME_DESCRIPTOR)
        field(SOURCELOCATIONNAME_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(VODSOURCENAME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ADBREAKOPPORTUNITIES_DESCRIPTOR.index -> builder.adBreakOpportunities =
                    deserializer.deserializeList(ADBREAKOPPORTUNITIES_DESCRIPTOR) {
                        val col0 = mutableListOf<AdBreakOpportunity>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeAdBreakOpportunityDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                ARN_DESCRIPTOR.index -> builder.arn = deserializeString()
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                HTTPPACKAGECONFIGURATIONS_DESCRIPTOR.index -> builder.httpPackageConfigurations =
                    deserializer.deserializeList(HTTPPACKAGECONFIGURATIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<HttpPackageConfiguration>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeHttpPackageConfigurationDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                LASTMODIFIEDTIME_DESCRIPTOR.index -> builder.lastModifiedTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                SOURCELOCATIONNAME_DESCRIPTOR.index -> builder.sourceLocationName = deserializeString()
                TAGS_DESCRIPTOR.index -> builder.tags =
                    deserializer.deserializeMap(TAGS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                VODSOURCENAME_DESCRIPTOR.index -> builder.vodSourceName = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
