// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediatailor.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The `segmentation_descriptor` message can contain advanced metadata fields, like content identifiers, to convey a wide range of information about the ad break. MediaTailor writes the ad metadata in the egress manifest as part of the `EXT-X-DATERANGE` or `EventStream` ad marker's SCTE-35 data.
 *
 * `segmentation_descriptor` messages must be sent with the `time_signal` message type.
 *
 * See the `segmentation_descriptor()` table of the 2022 SCTE-35 specification for more information.
 */
public class SegmentationDescriptor private constructor(builder: Builder) {
    /**
     * The segment number to assign to the `segmentation_descriptor.segment_num` message, as defined in section 10.3.3.1 of the 2022 SCTE-35 specification Values must be between 0 and 256, inclusive. The default value is 0.
     */
    public val segmentNum: kotlin.Int? = builder.segmentNum
    /**
     * The Event Identifier to assign to the `segmentation_descriptor.segmentation_event_id` message, as defined in section 10.3.3.1 of the 2022 SCTE-35 specification. The default value is 1.
     */
    public val segmentationEventId: kotlin.Int? = builder.segmentationEventId
    /**
     * The Type Identifier to assign to the `segmentation_descriptor.segmentation_type_id` message, as defined in section 10.3.3.1 of the 2022 SCTE-35 specification. Values must be between 0 and 256, inclusive. The default value is 48.
     */
    public val segmentationTypeId: kotlin.Int? = builder.segmentationTypeId
    /**
     * The Upid to assign to the `segmentation_descriptor.segmentation_upid` message, as defined in section 10.3.3.1 of the 2022 SCTE-35 specification. The value must be a hexadecimal string containing only the characters 0 though 9 and A through F. The default value is "" (an empty string).
     */
    public val segmentationUpid: kotlin.String? = builder.segmentationUpid
    /**
     * The Upid Type to assign to the `segmentation_descriptor.segmentation_upid_type` message, as defined in section 10.3.3.1 of the 2022 SCTE-35 specification. Values must be between 0 and 256, inclusive. The default value is 14.
     */
    public val segmentationUpidType: kotlin.Int? = builder.segmentationUpidType
    /**
     * The number of segments expected, which is assigned to the `segmentation_descriptor.segments_expectedS` message, as defined in section 10.3.3.1 of the 2022 SCTE-35 specification Values must be between 0 and 256, inclusive. The default value is 0.
     */
    public val segmentsExpected: kotlin.Int? = builder.segmentsExpected
    /**
     * The sub-segment number to assign to the `segmentation_descriptor.sub_segment_num` message, as defined in section 10.3.3.1 of the 2022 SCTE-35 specification. Values must be between 0 and 256, inclusive. The defualt value is null.
     */
    public val subSegmentNum: kotlin.Int? = builder.subSegmentNum
    /**
     * The number of sub-segments expected, which is assigned to the `segmentation_descriptor.sub_segments_expected` message, as defined in section 10.3.3.1 of the 2022 SCTE-35 specification. Values must be between 0 and 256, inclusive. The default value is null.
     */
    public val subSegmentsExpected: kotlin.Int? = builder.subSegmentsExpected

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediatailor.model.SegmentationDescriptor = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SegmentationDescriptor(")
        append("segmentNum=$segmentNum,")
        append("segmentationEventId=$segmentationEventId,")
        append("segmentationTypeId=$segmentationTypeId,")
        append("segmentationUpid=$segmentationUpid,")
        append("segmentationUpidType=$segmentationUpidType,")
        append("segmentsExpected=$segmentsExpected,")
        append("subSegmentNum=$subSegmentNum,")
        append("subSegmentsExpected=$subSegmentsExpected")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = segmentNum ?: 0
        result = 31 * result + (segmentationEventId ?: 0)
        result = 31 * result + (segmentationTypeId ?: 0)
        result = 31 * result + (segmentationUpid?.hashCode() ?: 0)
        result = 31 * result + (segmentationUpidType ?: 0)
        result = 31 * result + (segmentsExpected ?: 0)
        result = 31 * result + (subSegmentNum ?: 0)
        result = 31 * result + (subSegmentsExpected ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SegmentationDescriptor

        if (segmentNum != other.segmentNum) return false
        if (segmentationEventId != other.segmentationEventId) return false
        if (segmentationTypeId != other.segmentationTypeId) return false
        if (segmentationUpid != other.segmentationUpid) return false
        if (segmentationUpidType != other.segmentationUpidType) return false
        if (segmentsExpected != other.segmentsExpected) return false
        if (subSegmentNum != other.subSegmentNum) return false
        if (subSegmentsExpected != other.subSegmentsExpected) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediatailor.model.SegmentationDescriptor = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The segment number to assign to the `segmentation_descriptor.segment_num` message, as defined in section 10.3.3.1 of the 2022 SCTE-35 specification Values must be between 0 and 256, inclusive. The default value is 0.
         */
        public var segmentNum: kotlin.Int? = null
        /**
         * The Event Identifier to assign to the `segmentation_descriptor.segmentation_event_id` message, as defined in section 10.3.3.1 of the 2022 SCTE-35 specification. The default value is 1.
         */
        public var segmentationEventId: kotlin.Int? = null
        /**
         * The Type Identifier to assign to the `segmentation_descriptor.segmentation_type_id` message, as defined in section 10.3.3.1 of the 2022 SCTE-35 specification. Values must be between 0 and 256, inclusive. The default value is 48.
         */
        public var segmentationTypeId: kotlin.Int? = null
        /**
         * The Upid to assign to the `segmentation_descriptor.segmentation_upid` message, as defined in section 10.3.3.1 of the 2022 SCTE-35 specification. The value must be a hexadecimal string containing only the characters 0 though 9 and A through F. The default value is "" (an empty string).
         */
        public var segmentationUpid: kotlin.String? = null
        /**
         * The Upid Type to assign to the `segmentation_descriptor.segmentation_upid_type` message, as defined in section 10.3.3.1 of the 2022 SCTE-35 specification. Values must be between 0 and 256, inclusive. The default value is 14.
         */
        public var segmentationUpidType: kotlin.Int? = null
        /**
         * The number of segments expected, which is assigned to the `segmentation_descriptor.segments_expectedS` message, as defined in section 10.3.3.1 of the 2022 SCTE-35 specification Values must be between 0 and 256, inclusive. The default value is 0.
         */
        public var segmentsExpected: kotlin.Int? = null
        /**
         * The sub-segment number to assign to the `segmentation_descriptor.sub_segment_num` message, as defined in section 10.3.3.1 of the 2022 SCTE-35 specification. Values must be between 0 and 256, inclusive. The defualt value is null.
         */
        public var subSegmentNum: kotlin.Int? = null
        /**
         * The number of sub-segments expected, which is assigned to the `segmentation_descriptor.sub_segments_expected` message, as defined in section 10.3.3.1 of the 2022 SCTE-35 specification. Values must be between 0 and 256, inclusive. The default value is null.
         */
        public var subSegmentsExpected: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediatailor.model.SegmentationDescriptor) : this() {
            this.segmentNum = x.segmentNum
            this.segmentationEventId = x.segmentationEventId
            this.segmentationTypeId = x.segmentationTypeId
            this.segmentationUpid = x.segmentationUpid
            this.segmentationUpidType = x.segmentationUpidType
            this.segmentsExpected = x.segmentsExpected
            this.subSegmentNum = x.subSegmentNum
            this.subSegmentsExpected = x.subSegmentsExpected
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediatailor.model.SegmentationDescriptor = SegmentationDescriptor(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
