// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediatailor.model

import aws.smithy.kotlin.runtime.SdkDsl

public class GetChannelScheduleRequest private constructor(builder: Builder) {
    /**
     * The single audience for GetChannelScheduleRequest.
     */
    public val audience: kotlin.String? = builder.audience
    /**
     * The name of the channel associated with this Channel Schedule.
     */
    public val channelName: kotlin.String = requireNotNull(builder.channelName) { "A non-null value must be provided for channelName" }
    /**
     * The duration in minutes of the channel schedule.
     */
    public val durationMinutes: kotlin.String? = builder.durationMinutes
    /**
     * The maximum number of channel schedules that you want MediaTailor to return in response to the current request. If there are more than `MaxResults` channel schedules, use the value of `NextToken` in the response to get the next page of results.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * (Optional) If the playback configuration has more than `MaxResults` channel schedules, use `NextToken` to get the second and subsequent pages of results.
     *
     * For the first `GetChannelScheduleRequest` request, omit this value.
     *
     * For the second and subsequent requests, get the value of `NextToken` from the previous response and specify that value for `NextToken` in the request.
     *
     * If the previous response didn't include a `NextToken` element, there are no more channel schedules to get.
     */
    public val nextToken: kotlin.String? = builder.nextToken

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediatailor.model.GetChannelScheduleRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetChannelScheduleRequest(")
        append("audience=$audience,")
        append("channelName=$channelName,")
        append("durationMinutes=$durationMinutes,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = audience?.hashCode() ?: 0
        result = 31 * result + (channelName.hashCode())
        result = 31 * result + (durationMinutes?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetChannelScheduleRequest

        if (audience != other.audience) return false
        if (channelName != other.channelName) return false
        if (durationMinutes != other.durationMinutes) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediatailor.model.GetChannelScheduleRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The single audience for GetChannelScheduleRequest.
         */
        public var audience: kotlin.String? = null
        /**
         * The name of the channel associated with this Channel Schedule.
         */
        public var channelName: kotlin.String? = null
        /**
         * The duration in minutes of the channel schedule.
         */
        public var durationMinutes: kotlin.String? = null
        /**
         * The maximum number of channel schedules that you want MediaTailor to return in response to the current request. If there are more than `MaxResults` channel schedules, use the value of `NextToken` in the response to get the next page of results.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * (Optional) If the playback configuration has more than `MaxResults` channel schedules, use `NextToken` to get the second and subsequent pages of results.
         *
         * For the first `GetChannelScheduleRequest` request, omit this value.
         *
         * For the second and subsequent requests, get the value of `NextToken` from the previous response and specify that value for `NextToken` in the request.
         *
         * If the previous response didn't include a `NextToken` element, there are no more channel schedules to get.
         */
        public var nextToken: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediatailor.model.GetChannelScheduleRequest) : this() {
            this.audience = x.audience
            this.channelName = x.channelName
            this.durationMinutes = x.durationMinutes
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediatailor.model.GetChannelScheduleRequest = GetChannelScheduleRequest(this)

        internal fun correctErrors(): Builder {
            if (channelName == null) channelName = ""
            return this
        }
    }
}
