// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediatailor.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateVodSourceRequest private constructor(builder: Builder) {
    /**
     * A list of HTTP package configuration parameters for this VOD source.
     */
    public val httpPackageConfigurations: List<HttpPackageConfiguration> = requireNotNull(builder.httpPackageConfigurations) { "A non-null value must be provided for httpPackageConfigurations" }
    /**
     * The name of the source location for this VOD source.
     */
    public val sourceLocationName: kotlin.String = requireNotNull(builder.sourceLocationName) { "A non-null value must be provided for sourceLocationName" }
    /**
     * The tags to assign to the VOD source. Tags are key-value pairs that you can associate with Amazon resources to help with organization, access control, and cost tracking. For more information, see [Tagging AWS Elemental MediaTailor Resources](https://docs.aws.amazon.com/mediatailor/latest/ug/tagging.html).
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The name associated with the VOD source.>
     */
    public val vodSourceName: kotlin.String = requireNotNull(builder.vodSourceName) { "A non-null value must be provided for vodSourceName" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediatailor.model.CreateVodSourceRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateVodSourceRequest(")
        append("httpPackageConfigurations=$httpPackageConfigurations,")
        append("sourceLocationName=$sourceLocationName,")
        append("tags=$tags,")
        append("vodSourceName=$vodSourceName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = httpPackageConfigurations.hashCode()
        result = 31 * result + (sourceLocationName.hashCode())
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (vodSourceName.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateVodSourceRequest

        if (httpPackageConfigurations != other.httpPackageConfigurations) return false
        if (sourceLocationName != other.sourceLocationName) return false
        if (tags != other.tags) return false
        if (vodSourceName != other.vodSourceName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediatailor.model.CreateVodSourceRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A list of HTTP package configuration parameters for this VOD source.
         */
        public var httpPackageConfigurations: List<HttpPackageConfiguration>? = null
        /**
         * The name of the source location for this VOD source.
         */
        public var sourceLocationName: kotlin.String? = null
        /**
         * The tags to assign to the VOD source. Tags are key-value pairs that you can associate with Amazon resources to help with organization, access control, and cost tracking. For more information, see [Tagging AWS Elemental MediaTailor Resources](https://docs.aws.amazon.com/mediatailor/latest/ug/tagging.html).
         */
        public var tags: Map<String, String>? = null
        /**
         * The name associated with the VOD source.>
         */
        public var vodSourceName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediatailor.model.CreateVodSourceRequest) : this() {
            this.httpPackageConfigurations = x.httpPackageConfigurations
            this.sourceLocationName = x.sourceLocationName
            this.tags = x.tags
            this.vodSourceName = x.vodSourceName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediatailor.model.CreateVodSourceRequest = CreateVodSourceRequest(this)

        internal fun correctErrors(): Builder {
            if (httpPackageConfigurations == null) httpPackageConfigurations = emptyList()
            if (sourceLocationName == null) sourceLocationName = ""
            if (vodSourceName == null) vodSourceName = ""
            return this
        }
    }
}
