// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediatailor.serde

import aws.sdk.kotlin.services.mediatailor.model.AdBreak
import aws.sdk.kotlin.services.mediatailor.model.AudienceMedia
import aws.sdk.kotlin.services.mediatailor.model.ClipRange
import aws.sdk.kotlin.services.mediatailor.model.CreateProgramResponse
import aws.sdk.kotlin.services.mediatailor.model.MediaTailorException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import kotlin.collections.mutableListOf


internal class CreateProgramOperationDeserializer: HttpDeserializer.NonStreaming<CreateProgramResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): CreateProgramResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateProgramError(context, call, payload)
        }
        val builder = CreateProgramResponse.Builder()

        if (payload != null) {
            deserializeCreateProgramOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwCreateProgramError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw MediaTailorException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        else -> MediaTailorException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateProgramOperationBody(builder: CreateProgramResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ADBREAKS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("AdBreaks"))
    val ARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Arn"))
    val AUDIENCEMEDIA_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("AudienceMedia"))
    val CHANNELNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ChannelName"))
    val CLIPRANGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ClipRange"))
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreationTime"))
    val DURATIONMILLIS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("DurationMillis"))
    val LIVESOURCENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("LiveSourceName"))
    val PROGRAMNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ProgramName"))
    val SCHEDULEDSTARTTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("ScheduledStartTime"))
    val SOURCELOCATIONNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SourceLocationName"))
    val VODSOURCENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("VodSourceName"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ADBREAKS_DESCRIPTOR)
        field(ARN_DESCRIPTOR)
        field(AUDIENCEMEDIA_DESCRIPTOR)
        field(CHANNELNAME_DESCRIPTOR)
        field(CLIPRANGE_DESCRIPTOR)
        field(CREATIONTIME_DESCRIPTOR)
        field(DURATIONMILLIS_DESCRIPTOR)
        field(LIVESOURCENAME_DESCRIPTOR)
        field(PROGRAMNAME_DESCRIPTOR)
        field(SCHEDULEDSTARTTIME_DESCRIPTOR)
        field(SOURCELOCATIONNAME_DESCRIPTOR)
        field(VODSOURCENAME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ADBREAKS_DESCRIPTOR.index -> builder.adBreaks =
                    deserializer.deserializeList(ADBREAKS_DESCRIPTOR) {
                        val col0 = mutableListOf<AdBreak>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeAdBreakDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                ARN_DESCRIPTOR.index -> builder.arn = deserializeString()
                AUDIENCEMEDIA_DESCRIPTOR.index -> builder.audienceMedia =
                    deserializer.deserializeList(AUDIENCEMEDIA_DESCRIPTOR) {
                        val col0 = mutableListOf<AudienceMedia>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeAudienceMediaDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                CHANNELNAME_DESCRIPTOR.index -> builder.channelName = deserializeString()
                CLIPRANGE_DESCRIPTOR.index -> builder.clipRange = deserializeClipRangeDocument(deserializer)
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                DURATIONMILLIS_DESCRIPTOR.index -> builder.durationMillis = deserializeLong()
                LIVESOURCENAME_DESCRIPTOR.index -> builder.liveSourceName = deserializeString()
                PROGRAMNAME_DESCRIPTOR.index -> builder.programName = deserializeString()
                SCHEDULEDSTARTTIME_DESCRIPTOR.index -> builder.scheduledStartTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                SOURCELOCATIONNAME_DESCRIPTOR.index -> builder.sourceLocationName = deserializeString()
                VODSOURCENAME_DESCRIPTOR.index -> builder.vodSourceName = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
