// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediatailor.paginators

import aws.sdk.kotlin.services.mediatailor.MediaTailorClient
import aws.sdk.kotlin.services.mediatailor.model.Alert
import aws.sdk.kotlin.services.mediatailor.model.Channel
import aws.sdk.kotlin.services.mediatailor.model.GetChannelScheduleRequest
import aws.sdk.kotlin.services.mediatailor.model.GetChannelScheduleResponse
import aws.sdk.kotlin.services.mediatailor.model.ListAlertsRequest
import aws.sdk.kotlin.services.mediatailor.model.ListAlertsResponse
import aws.sdk.kotlin.services.mediatailor.model.ListChannelsRequest
import aws.sdk.kotlin.services.mediatailor.model.ListChannelsResponse
import aws.sdk.kotlin.services.mediatailor.model.ListLiveSourcesRequest
import aws.sdk.kotlin.services.mediatailor.model.ListLiveSourcesResponse
import aws.sdk.kotlin.services.mediatailor.model.ListPlaybackConfigurationsRequest
import aws.sdk.kotlin.services.mediatailor.model.ListPlaybackConfigurationsResponse
import aws.sdk.kotlin.services.mediatailor.model.ListPrefetchSchedulesRequest
import aws.sdk.kotlin.services.mediatailor.model.ListPrefetchSchedulesResponse
import aws.sdk.kotlin.services.mediatailor.model.ListSourceLocationsRequest
import aws.sdk.kotlin.services.mediatailor.model.ListSourceLocationsResponse
import aws.sdk.kotlin.services.mediatailor.model.ListVodSourcesRequest
import aws.sdk.kotlin.services.mediatailor.model.ListVodSourcesResponse
import aws.sdk.kotlin.services.mediatailor.model.LiveSource
import aws.sdk.kotlin.services.mediatailor.model.PlaybackConfiguration
import aws.sdk.kotlin.services.mediatailor.model.PrefetchSchedule
import aws.sdk.kotlin.services.mediatailor.model.ScheduleEntry
import aws.sdk.kotlin.services.mediatailor.model.SourceLocation
import aws.sdk.kotlin.services.mediatailor.model.VodSource
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [GetChannelScheduleResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetChannelScheduleRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetChannelScheduleResponse]
 */
public fun MediaTailorClient.getChannelSchedulePaginated(initialRequest: GetChannelScheduleRequest): Flow<GetChannelScheduleResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@getChannelSchedulePaginated.getChannelSchedule(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [GetChannelScheduleResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetChannelScheduleResponse]
 */
public fun MediaTailorClient.getChannelSchedulePaginated(block: GetChannelScheduleRequest.Builder.() -> Unit): Flow<GetChannelScheduleResponse> =
    getChannelSchedulePaginated(GetChannelScheduleRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [getChannelSchedulePaginated]
 * to access the nested member [ScheduleEntry]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ScheduleEntry]
 */
@JvmName("getChannelScheduleResponseScheduleEntry")
public fun Flow<GetChannelScheduleResponse>.items(): Flow<ScheduleEntry> =
    transform() { response ->
        response.items?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListAlertsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListAlertsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAlertsResponse]
 */
public fun MediaTailorClient.listAlertsPaginated(initialRequest: ListAlertsRequest): Flow<ListAlertsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listAlertsPaginated.listAlerts(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListAlertsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAlertsResponse]
 */
public fun MediaTailorClient.listAlertsPaginated(block: ListAlertsRequest.Builder.() -> Unit): Flow<ListAlertsResponse> =
    listAlertsPaginated(ListAlertsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listAlertsPaginated]
 * to access the nested member [Alert]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Alert]
 */
@JvmName("listAlertsResponseAlert")
public fun Flow<ListAlertsResponse>.items(): Flow<Alert> =
    transform() { response ->
        response.items?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListChannelsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListChannelsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListChannelsResponse]
 */
public fun MediaTailorClient.listChannelsPaginated(initialRequest: ListChannelsRequest = ListChannelsRequest { }): Flow<ListChannelsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listChannelsPaginated.listChannels(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListChannelsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListChannelsResponse]
 */
public fun MediaTailorClient.listChannelsPaginated(block: ListChannelsRequest.Builder.() -> Unit): Flow<ListChannelsResponse> =
    listChannelsPaginated(ListChannelsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listChannelsPaginated]
 * to access the nested member [Channel]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Channel]
 */
@JvmName("listChannelsResponseChannel")
public fun Flow<ListChannelsResponse>.items(): Flow<Channel> =
    transform() { response ->
        response.items?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListLiveSourcesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListLiveSourcesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListLiveSourcesResponse]
 */
public fun MediaTailorClient.listLiveSourcesPaginated(initialRequest: ListLiveSourcesRequest): Flow<ListLiveSourcesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listLiveSourcesPaginated.listLiveSources(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListLiveSourcesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListLiveSourcesResponse]
 */
public fun MediaTailorClient.listLiveSourcesPaginated(block: ListLiveSourcesRequest.Builder.() -> Unit): Flow<ListLiveSourcesResponse> =
    listLiveSourcesPaginated(ListLiveSourcesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listLiveSourcesPaginated]
 * to access the nested member [LiveSource]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [LiveSource]
 */
@JvmName("listLiveSourcesResponseLiveSource")
public fun Flow<ListLiveSourcesResponse>.items(): Flow<LiveSource> =
    transform() { response ->
        response.items?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListPlaybackConfigurationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListPlaybackConfigurationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPlaybackConfigurationsResponse]
 */
public fun MediaTailorClient.listPlaybackConfigurationsPaginated(initialRequest: ListPlaybackConfigurationsRequest = ListPlaybackConfigurationsRequest { }): Flow<ListPlaybackConfigurationsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listPlaybackConfigurationsPaginated.listPlaybackConfigurations(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListPlaybackConfigurationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPlaybackConfigurationsResponse]
 */
public fun MediaTailorClient.listPlaybackConfigurationsPaginated(block: ListPlaybackConfigurationsRequest.Builder.() -> Unit): Flow<ListPlaybackConfigurationsResponse> =
    listPlaybackConfigurationsPaginated(ListPlaybackConfigurationsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listPlaybackConfigurationsPaginated]
 * to access the nested member [PlaybackConfiguration]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [PlaybackConfiguration]
 */
@JvmName("listPlaybackConfigurationsResponsePlaybackConfiguration")
public fun Flow<ListPlaybackConfigurationsResponse>.items(): Flow<PlaybackConfiguration> =
    transform() { response ->
        response.items?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListPrefetchSchedulesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListPrefetchSchedulesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPrefetchSchedulesResponse]
 */
public fun MediaTailorClient.listPrefetchSchedulesPaginated(initialRequest: ListPrefetchSchedulesRequest): Flow<ListPrefetchSchedulesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listPrefetchSchedulesPaginated.listPrefetchSchedules(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListPrefetchSchedulesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPrefetchSchedulesResponse]
 */
public fun MediaTailorClient.listPrefetchSchedulesPaginated(block: ListPrefetchSchedulesRequest.Builder.() -> Unit): Flow<ListPrefetchSchedulesResponse> =
    listPrefetchSchedulesPaginated(ListPrefetchSchedulesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listPrefetchSchedulesPaginated]
 * to access the nested member [PrefetchSchedule]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [PrefetchSchedule]
 */
@JvmName("listPrefetchSchedulesResponsePrefetchSchedule")
public fun Flow<ListPrefetchSchedulesResponse>.items(): Flow<PrefetchSchedule> =
    transform() { response ->
        response.items?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListSourceLocationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListSourceLocationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSourceLocationsResponse]
 */
public fun MediaTailorClient.listSourceLocationsPaginated(initialRequest: ListSourceLocationsRequest = ListSourceLocationsRequest { }): Flow<ListSourceLocationsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listSourceLocationsPaginated.listSourceLocations(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListSourceLocationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSourceLocationsResponse]
 */
public fun MediaTailorClient.listSourceLocationsPaginated(block: ListSourceLocationsRequest.Builder.() -> Unit): Flow<ListSourceLocationsResponse> =
    listSourceLocationsPaginated(ListSourceLocationsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listSourceLocationsPaginated]
 * to access the nested member [SourceLocation]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SourceLocation]
 */
@JvmName("listSourceLocationsResponseSourceLocation")
public fun Flow<ListSourceLocationsResponse>.items(): Flow<SourceLocation> =
    transform() { response ->
        response.items?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListVodSourcesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListVodSourcesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListVodSourcesResponse]
 */
public fun MediaTailorClient.listVodSourcesPaginated(initialRequest: ListVodSourcesRequest): Flow<ListVodSourcesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listVodSourcesPaginated.listVodSources(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListVodSourcesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListVodSourcesResponse]
 */
public fun MediaTailorClient.listVodSourcesPaginated(block: ListVodSourcesRequest.Builder.() -> Unit): Flow<ListVodSourcesResponse> =
    listVodSourcesPaginated(ListVodSourcesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listVodSourcesPaginated]
 * to access the nested member [VodSource]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [VodSource]
 */
@JvmName("listVodSourcesResponseVodSource")
public fun Flow<ListVodSourcesResponse>.items(): Flow<VodSource> =
    transform() { response ->
        response.items?.forEach {
            emit(it)
        }
    }
