// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediatailor.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Returns Amazon CloudWatch log settings for a playback configuration.
 */
public class LogConfiguration private constructor(builder: Builder) {
    /**
     * The percentage of session logs that MediaTailor sends to your Cloudwatch Logs account. For example, if your playback configuration has 1000 sessions and `percentEnabled` is set to `60`, MediaTailor sends logs for 600 of the sessions to CloudWatch Logs. MediaTailor decides at random which of the playback configuration sessions to send logs for. If you want to view logs for a specific session, you can use the [debug log mode](https://docs.aws.amazon.com/mediatailor/latest/ug/debug-log-mode.html).
     *
     * Valid values: `0` - `100`
     */
    public val percentEnabled: kotlin.Int = builder.percentEnabled

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediatailor.model.LogConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LogConfiguration(")
        append("percentEnabled=$percentEnabled")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = percentEnabled
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LogConfiguration

        if (percentEnabled != other.percentEnabled) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediatailor.model.LogConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The percentage of session logs that MediaTailor sends to your Cloudwatch Logs account. For example, if your playback configuration has 1000 sessions and `percentEnabled` is set to `60`, MediaTailor sends logs for 600 of the sessions to CloudWatch Logs. MediaTailor decides at random which of the playback configuration sessions to send logs for. If you want to view logs for a specific session, you can use the [debug log mode](https://docs.aws.amazon.com/mediatailor/latest/ug/debug-log-mode.html).
         *
         * Valid values: `0` - `100`
         */
        public var percentEnabled: kotlin.Int = 0

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediatailor.model.LogConfiguration) : this() {
            this.percentEnabled = x.percentEnabled
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediatailor.model.LogConfiguration = LogConfiguration(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
