// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediatailor.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Alert configuration parameters.
 */
public class Alert private constructor(builder: Builder) {
    /**
     * The code for the alert. For example, `NOT_PROCESSED`.
     */
    public val alertCode: kotlin.String = requireNotNull(builder.alertCode) { "A non-null value must be provided for alertCode" }
    /**
     * If an alert is generated for a resource, an explanation of the reason for the alert.
     */
    public val alertMessage: kotlin.String = requireNotNull(builder.alertMessage) { "A non-null value must be provided for alertMessage" }
    /**
     * The category that MediaTailor assigns to the alert.
     */
    public val category: aws.sdk.kotlin.services.mediatailor.model.AlertCategory? = builder.category
    /**
     * The timestamp when the alert was last modified.
     */
    public val lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.lastModifiedTime) { "A non-null value must be provided for lastModifiedTime" }
    /**
     * The Amazon Resource Names (ARNs) related to this alert.
     */
    public val relatedResourceArns: List<String> = requireNotNull(builder.relatedResourceArns) { "A non-null value must be provided for relatedResourceArns" }
    /**
     * The Amazon Resource Name (ARN) of the resource.
     */
    public val resourceArn: kotlin.String = requireNotNull(builder.resourceArn) { "A non-null value must be provided for resourceArn" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediatailor.model.Alert = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Alert(")
        append("alertCode=$alertCode,")
        append("alertMessage=$alertMessage,")
        append("category=$category,")
        append("lastModifiedTime=$lastModifiedTime,")
        append("relatedResourceArns=$relatedResourceArns,")
        append("resourceArn=$resourceArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = alertCode.hashCode()
        result = 31 * result + (alertMessage.hashCode())
        result = 31 * result + (category?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedTime.hashCode())
        result = 31 * result + (relatedResourceArns.hashCode())
        result = 31 * result + (resourceArn.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Alert

        if (alertCode != other.alertCode) return false
        if (alertMessage != other.alertMessage) return false
        if (category != other.category) return false
        if (lastModifiedTime != other.lastModifiedTime) return false
        if (relatedResourceArns != other.relatedResourceArns) return false
        if (resourceArn != other.resourceArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediatailor.model.Alert = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The code for the alert. For example, `NOT_PROCESSED`.
         */
        public var alertCode: kotlin.String? = null
        /**
         * If an alert is generated for a resource, an explanation of the reason for the alert.
         */
        public var alertMessage: kotlin.String? = null
        /**
         * The category that MediaTailor assigns to the alert.
         */
        public var category: aws.sdk.kotlin.services.mediatailor.model.AlertCategory? = null
        /**
         * The timestamp when the alert was last modified.
         */
        public var lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Names (ARNs) related to this alert.
         */
        public var relatedResourceArns: List<String>? = null
        /**
         * The Amazon Resource Name (ARN) of the resource.
         */
        public var resourceArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediatailor.model.Alert) : this() {
            this.alertCode = x.alertCode
            this.alertMessage = x.alertMessage
            this.category = x.category
            this.lastModifiedTime = x.lastModifiedTime
            this.relatedResourceArns = x.relatedResourceArns
            this.resourceArn = x.resourceArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediatailor.model.Alert = Alert(this)

        internal fun correctErrors(): Builder {
            if (alertCode == null) alertCode = ""
            if (alertMessage == null) alertMessage = ""
            if (lastModifiedTime == null) lastModifiedTime = Instant.fromEpochSeconds(0)
            if (relatedResourceArns == null) relatedResourceArns = emptyList()
            if (resourceArn == null) resourceArn = ""
            return this
        }
    }
}
