// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediatailor.serde

import aws.sdk.kotlin.services.mediatailor.model.ChannelState
import aws.sdk.kotlin.services.mediatailor.model.DescribeChannelResponse
import aws.sdk.kotlin.services.mediatailor.model.LogConfigurationForChannel
import aws.sdk.kotlin.services.mediatailor.model.MediaTailorException
import aws.sdk.kotlin.services.mediatailor.model.ResponseOutputItem
import aws.sdk.kotlin.services.mediatailor.model.SlateSource
import aws.sdk.kotlin.services.mediatailor.model.TimeShiftConfiguration
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import kotlin.collections.mutableListOf
import kotlin.collections.mutableMapOf


internal class DescribeChannelOperationDeserializer: HttpDeserialize<DescribeChannelResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): DescribeChannelResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeChannelError(context, call)
        }
        val builder = DescribeChannelResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeChannelOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwDescribeChannelError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw MediaTailorException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        else -> MediaTailorException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeChannelOperationBody(builder: DescribeChannelResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Arn"))
    val CHANNELNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ChannelName"))
    val CHANNELSTATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("ChannelState"))
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreationTime"))
    val FILLERSLATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("FillerSlate"))
    val LASTMODIFIEDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LastModifiedTime"))
    val LOGCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("LogConfiguration"))
    val OUTPUTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Outputs"))
    val PLAYBACKMODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("PlaybackMode"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("tags"))
    val TIER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Tier"))
    val TIMESHIFTCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("TimeShiftConfiguration"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ARN_DESCRIPTOR)
        field(CHANNELNAME_DESCRIPTOR)
        field(CHANNELSTATE_DESCRIPTOR)
        field(CREATIONTIME_DESCRIPTOR)
        field(FILLERSLATE_DESCRIPTOR)
        field(LASTMODIFIEDTIME_DESCRIPTOR)
        field(LOGCONFIGURATION_DESCRIPTOR)
        field(OUTPUTS_DESCRIPTOR)
        field(PLAYBACKMODE_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(TIER_DESCRIPTOR)
        field(TIMESHIFTCONFIGURATION_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ARN_DESCRIPTOR.index -> builder.arn = deserializeString()
                CHANNELNAME_DESCRIPTOR.index -> builder.channelName = deserializeString()
                CHANNELSTATE_DESCRIPTOR.index -> builder.channelState = deserializeString().let { ChannelState.fromValue(it) }
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                FILLERSLATE_DESCRIPTOR.index -> builder.fillerSlate = deserializeSlateSourceDocument(deserializer)
                LASTMODIFIEDTIME_DESCRIPTOR.index -> builder.lastModifiedTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                LOGCONFIGURATION_DESCRIPTOR.index -> builder.logConfiguration = deserializeLogConfigurationForChannelDocument(deserializer)
                OUTPUTS_DESCRIPTOR.index -> builder.outputs =
                    deserializer.deserializeList(OUTPUTS_DESCRIPTOR) {
                        val col0 = mutableListOf<ResponseOutputItem>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeResponseOutputItemDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                PLAYBACKMODE_DESCRIPTOR.index -> builder.playbackMode = deserializeString()
                TAGS_DESCRIPTOR.index -> builder.tags =
                    deserializer.deserializeMap(TAGS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                TIER_DESCRIPTOR.index -> builder.tier = deserializeString()
                TIMESHIFTCONFIGURATION_DESCRIPTOR.index -> builder.timeShiftConfiguration = deserializeTimeShiftConfigurationDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
