// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediatailor.serde

import aws.sdk.kotlin.services.mediatailor.model.AdBreak
import aws.sdk.kotlin.services.mediatailor.model.CreateProgramRequest
import aws.sdk.kotlin.services.mediatailor.model.ScheduleConfiguration
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class CreateProgramOperationSerializer: HttpSerialize<CreateProgramRequest> {
    override suspend fun serialize(context: ExecutionContext, input: CreateProgramRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path.encodedSegments {
                add(PercentEncoding.Path.encode("channel"))
                add(PercentEncoding.SmithyLabel.encode("${input.channelName}"))
                add(PercentEncoding.Path.encode("program"))
                add(PercentEncoding.SmithyLabel.encode("${input.programName}"))
            }
        }

        val payload = serializeCreateProgramOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCreateProgramOperationBody(context: ExecutionContext, input: CreateProgramRequest): ByteArray {
    val serializer = JsonSerializer()
    val ADBREAKS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("AdBreaks"))
    val LIVESOURCENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("LiveSourceName"))
    val SCHEDULECONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ScheduleConfiguration"))
    val SOURCELOCATIONNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SourceLocationName"))
    val VODSOURCENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("VodSourceName"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ADBREAKS_DESCRIPTOR)
        field(LIVESOURCENAME_DESCRIPTOR)
        field(SCHEDULECONFIGURATION_DESCRIPTOR)
        field(SOURCELOCATIONNAME_DESCRIPTOR)
        field(VODSOURCENAME_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        if (input.adBreaks != null) {
            listField(ADBREAKS_DESCRIPTOR) {
                for (el0 in input.adBreaks) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeAdBreakDocument))
                }
            }
        }
        input.liveSourceName?.let { field(LIVESOURCENAME_DESCRIPTOR, it) }
        input.scheduleConfiguration?.let { field(SCHEDULECONFIGURATION_DESCRIPTOR, it, ::serializeScheduleConfigurationDocument) }
        field(SOURCELOCATIONNAME_DESCRIPTOR, input.sourceLocationName)
        input.vodSourceName?.let { field(VODSOURCENAME_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
