// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediatailor.paginators

import aws.sdk.kotlin.services.mediatailor.MediaTailorClient
import aws.sdk.kotlin.services.mediatailor.model.Alert
import aws.sdk.kotlin.services.mediatailor.model.ListAlertsRequest
import aws.sdk.kotlin.services.mediatailor.model.ListAlertsResponse
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListAlertsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListAlertsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAlertsResponse]
 */
public fun MediaTailorClient.listAlertsPaginated(initialRequest: ListAlertsRequest): Flow<ListAlertsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listAlertsPaginated.listAlerts(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListAlertsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAlertsResponse]
 */
public fun MediaTailorClient.listAlertsPaginated(block: ListAlertsRequest.Builder.() -> Unit): Flow<ListAlertsResponse> =
    listAlertsPaginated(ListAlertsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listAlertsPaginated]
 * to access the nested member [Alert]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Alert]
 */
@JvmName("listAlertsResponseAlert")
public fun Flow<ListAlertsResponse>.items(): Flow<Alert> =
    transform() { response ->
        response.items?.forEach {
            emit(it)
        }
    }
