// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediatailor.model

import aws.smithy.kotlin.runtime.time.Instant

public class UpdateVodSourceResponse private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) associated with the VOD source.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The timestamp that indicates when the VOD source was created.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * A list of HTTP package configurations for the VOD source on this account.
     */
    public val httpPackageConfigurations: List<HttpPackageConfiguration>? = builder.httpPackageConfigurations
    /**
     * The timestamp that indicates when the VOD source was last modified.
     */
    public val lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedTime
    /**
     * The name of the source location associated with the VOD source.
     */
    public val sourceLocationName: kotlin.String? = builder.sourceLocationName
    /**
     * The tags to assign to the VOD source. Tags are key-value pairs that you can associate with Amazon resources to help with organization, access control, and cost tracking. For more information, see [Tagging AWS Elemental MediaTailor Resources](https://docs.aws.amazon.com/mediatailor/latest/ug/tagging.html).
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The name of the VOD source.
     */
    public val vodSourceName: kotlin.String? = builder.vodSourceName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediatailor.model.UpdateVodSourceResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateVodSourceResponse(")
        append("arn=$arn,")
        append("creationTime=$creationTime,")
        append("httpPackageConfigurations=$httpPackageConfigurations,")
        append("lastModifiedTime=$lastModifiedTime,")
        append("sourceLocationName=$sourceLocationName,")
        append("tags=$tags,")
        append("vodSourceName=$vodSourceName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (httpPackageConfigurations?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedTime?.hashCode() ?: 0)
        result = 31 * result + (sourceLocationName?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (vodSourceName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateVodSourceResponse

        if (arn != other.arn) return false
        if (creationTime != other.creationTime) return false
        if (httpPackageConfigurations != other.httpPackageConfigurations) return false
        if (lastModifiedTime != other.lastModifiedTime) return false
        if (sourceLocationName != other.sourceLocationName) return false
        if (tags != other.tags) return false
        if (vodSourceName != other.vodSourceName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediatailor.model.UpdateVodSourceResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) associated with the VOD source.
         */
        public var arn: kotlin.String? = null
        /**
         * The timestamp that indicates when the VOD source was created.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A list of HTTP package configurations for the VOD source on this account.
         */
        public var httpPackageConfigurations: List<HttpPackageConfiguration>? = null
        /**
         * The timestamp that indicates when the VOD source was last modified.
         */
        public var lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the source location associated with the VOD source.
         */
        public var sourceLocationName: kotlin.String? = null
        /**
         * The tags to assign to the VOD source. Tags are key-value pairs that you can associate with Amazon resources to help with organization, access control, and cost tracking. For more information, see [Tagging AWS Elemental MediaTailor Resources](https://docs.aws.amazon.com/mediatailor/latest/ug/tagging.html).
         */
        public var tags: Map<String, String>? = null
        /**
         * The name of the VOD source.
         */
        public var vodSourceName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediatailor.model.UpdateVodSourceResponse) : this() {
            this.arn = x.arn
            this.creationTime = x.creationTime
            this.httpPackageConfigurations = x.httpPackageConfigurations
            this.lastModifiedTime = x.lastModifiedTime
            this.sourceLocationName = x.sourceLocationName
            this.tags = x.tags
            this.vodSourceName = x.vodSourceName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediatailor.model.UpdateVodSourceResponse = UpdateVodSourceResponse(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
