// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediatailor.model



/**
 * AWS Secrets Manager access token configuration parameters. For information about Secrets Manager access token authentication, see [Working with AWS Secrets Manager access token authentication](https://docs.aws.amazon.com/mediatailor/latest/ug/channel-assembly-access-configuration-access-token.html).
 */
public class SecretsManagerAccessTokenConfiguration private constructor(builder: Builder) {
    /**
     * The name of the HTTP header used to supply the access token in requests to the source location.
     */
    public val headerName: kotlin.String? = builder.headerName
    /**
     * The Amazon Resource Name (ARN) of the AWS Secrets Manager secret that contains the access token.
     */
    public val secretArn: kotlin.String? = builder.secretArn
    /**
     * The AWS Secrets Manager [SecretString](https://docs.aws.amazon.com/secretsmanager/latest/apireference/API_CreateSecret.html#SecretsManager-CreateSecret-request-SecretString.html) key associated with the access token. MediaTailor uses the key to look up SecretString key and value pair containing the access token.
     */
    public val secretStringKey: kotlin.String? = builder.secretStringKey

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediatailor.model.SecretsManagerAccessTokenConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SecretsManagerAccessTokenConfiguration(")
        append("headerName=$headerName,")
        append("secretArn=$secretArn,")
        append("secretStringKey=$secretStringKey")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = headerName?.hashCode() ?: 0
        result = 31 * result + (secretArn?.hashCode() ?: 0)
        result = 31 * result + (secretStringKey?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SecretsManagerAccessTokenConfiguration

        if (headerName != other.headerName) return false
        if (secretArn != other.secretArn) return false
        if (secretStringKey != other.secretStringKey) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediatailor.model.SecretsManagerAccessTokenConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the HTTP header used to supply the access token in requests to the source location.
         */
        public var headerName: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the AWS Secrets Manager secret that contains the access token.
         */
        public var secretArn: kotlin.String? = null
        /**
         * The AWS Secrets Manager [SecretString](https://docs.aws.amazon.com/secretsmanager/latest/apireference/API_CreateSecret.html#SecretsManager-CreateSecret-request-SecretString.html) key associated with the access token. MediaTailor uses the key to look up SecretString key and value pair containing the access token.
         */
        public var secretStringKey: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediatailor.model.SecretsManagerAccessTokenConfiguration) : this() {
            this.headerName = x.headerName
            this.secretArn = x.secretArn
            this.secretStringKey = x.secretStringKey
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediatailor.model.SecretsManagerAccessTokenConfiguration = SecretsManagerAccessTokenConfiguration(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
