// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediatailor.model



/**
 * A prefetch schedule allows you to tell MediaTailor to fetch and prepare certain ads before an ad break happens. For more information about ad prefetching, see [Using ad prefetching](https://docs.aws.amazon.com/mediatailor/latest/ug/prefetching-ads.html) in the *MediaTailor User Guide*.
 */
public class PrefetchSchedule private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the prefetch schedule.
     */
    public val arn: kotlin.String = requireNotNull(builder.arn) { "A non-null value must be provided for arn" }
    /**
     * Consumption settings determine how, and when, MediaTailor places the prefetched ads into ad breaks. Ad consumption occurs within a span of time that you define, called a *consumption window*. You can designate which ad breaks that MediaTailor fills with prefetch ads by setting avail matching criteria.
     */
    public val consumption: aws.sdk.kotlin.services.mediatailor.model.PrefetchConsumption? = builder.consumption
    /**
     * The name of the prefetch schedule. The name must be unique among all prefetch schedules that are associated with the specified playback configuration.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The name of the playback configuration to create the prefetch schedule for.
     */
    public val playbackConfigurationName: kotlin.String = requireNotNull(builder.playbackConfigurationName) { "A non-null value must be provided for playbackConfigurationName" }
    /**
     * A complex type that contains settings for prefetch retrieval from the ad decision server (ADS).
     */
    public val retrieval: aws.sdk.kotlin.services.mediatailor.model.PrefetchRetrieval? = builder.retrieval
    /**
     * An optional stream identifier that you can specify in order to prefetch for multiple streams that use the same playback configuration.
     */
    public val streamId: kotlin.String? = builder.streamId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediatailor.model.PrefetchSchedule = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PrefetchSchedule(")
        append("arn=$arn,")
        append("consumption=$consumption,")
        append("name=$name,")
        append("playbackConfigurationName=$playbackConfigurationName,")
        append("retrieval=$retrieval,")
        append("streamId=$streamId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn.hashCode()
        result = 31 * result + (consumption?.hashCode() ?: 0)
        result = 31 * result + (name.hashCode())
        result = 31 * result + (playbackConfigurationName.hashCode())
        result = 31 * result + (retrieval?.hashCode() ?: 0)
        result = 31 * result + (streamId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PrefetchSchedule

        if (arn != other.arn) return false
        if (consumption != other.consumption) return false
        if (name != other.name) return false
        if (playbackConfigurationName != other.playbackConfigurationName) return false
        if (retrieval != other.retrieval) return false
        if (streamId != other.streamId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediatailor.model.PrefetchSchedule = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the prefetch schedule.
         */
        public var arn: kotlin.String? = null
        /**
         * Consumption settings determine how, and when, MediaTailor places the prefetched ads into ad breaks. Ad consumption occurs within a span of time that you define, called a *consumption window*. You can designate which ad breaks that MediaTailor fills with prefetch ads by setting avail matching criteria.
         */
        public var consumption: aws.sdk.kotlin.services.mediatailor.model.PrefetchConsumption? = null
        /**
         * The name of the prefetch schedule. The name must be unique among all prefetch schedules that are associated with the specified playback configuration.
         */
        public var name: kotlin.String? = null
        /**
         * The name of the playback configuration to create the prefetch schedule for.
         */
        public var playbackConfigurationName: kotlin.String? = null
        /**
         * A complex type that contains settings for prefetch retrieval from the ad decision server (ADS).
         */
        public var retrieval: aws.sdk.kotlin.services.mediatailor.model.PrefetchRetrieval? = null
        /**
         * An optional stream identifier that you can specify in order to prefetch for multiple streams that use the same playback configuration.
         */
        public var streamId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediatailor.model.PrefetchSchedule) : this() {
            this.arn = x.arn
            this.consumption = x.consumption
            this.name = x.name
            this.playbackConfigurationName = x.playbackConfigurationName
            this.retrieval = x.retrieval
            this.streamId = x.streamId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediatailor.model.PrefetchSchedule = PrefetchSchedule(this)

        /**
         * construct an [aws.sdk.kotlin.services.mediatailor.model.PrefetchConsumption] inside the given [block]
         */
        public fun consumption(block: aws.sdk.kotlin.services.mediatailor.model.PrefetchConsumption.Builder.() -> kotlin.Unit) {
            this.consumption = aws.sdk.kotlin.services.mediatailor.model.PrefetchConsumption.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediatailor.model.PrefetchRetrieval] inside the given [block]
         */
        public fun retrieval(block: aws.sdk.kotlin.services.mediatailor.model.PrefetchRetrieval.Builder.() -> kotlin.Unit) {
            this.retrieval = aws.sdk.kotlin.services.mediatailor.model.PrefetchRetrieval.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (arn == null) arn = ""
            if (name == null) name = ""
            if (playbackConfigurationName == null) playbackConfigurationName = ""
            return this
        }
    }
}
