// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediatailor.model



public class ListPrefetchSchedulesRequest private constructor(builder: Builder) {
    /**
     * The maximum number of prefetch schedules that you want MediaTailor to return in response to the current request. If there are more than `MaxResults` prefetch schedules, use the value of `NextToken` in the response to get the next page of results.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * (Optional) If the playback configuration has more than `MaxResults` prefetch schedules, use `NextToken` to get the second and subsequent pages of results.
     *
     *  For the first `ListPrefetchSchedulesRequest` request, omit this value.
     *
     *  For the second and subsequent requests, get the value of `NextToken` from the previous response and specify that value for `NextToken` in the request.
     *
     *  If the previous response didn't include a `NextToken` element, there are no more prefetch schedules to get.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * Retrieves the prefetch schedule(s) for a specific playback configuration.
     */
    public val playbackConfigurationName: kotlin.String = requireNotNull(builder.playbackConfigurationName) { "A non-null value must be provided for playbackConfigurationName" }
    /**
     * An optional filtering parameter whereby MediaTailor filters the prefetch schedules to include only specific streams.
     */
    public val streamId: kotlin.String? = builder.streamId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediatailor.model.ListPrefetchSchedulesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListPrefetchSchedulesRequest(")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("playbackConfigurationName=$playbackConfigurationName,")
        append("streamId=$streamId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = maxResults ?: 0
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (playbackConfigurationName.hashCode())
        result = 31 * result + (streamId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListPrefetchSchedulesRequest

        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (playbackConfigurationName != other.playbackConfigurationName) return false
        if (streamId != other.streamId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediatailor.model.ListPrefetchSchedulesRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The maximum number of prefetch schedules that you want MediaTailor to return in response to the current request. If there are more than `MaxResults` prefetch schedules, use the value of `NextToken` in the response to get the next page of results.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * (Optional) If the playback configuration has more than `MaxResults` prefetch schedules, use `NextToken` to get the second and subsequent pages of results.
         *
         *  For the first `ListPrefetchSchedulesRequest` request, omit this value.
         *
         *  For the second and subsequent requests, get the value of `NextToken` from the previous response and specify that value for `NextToken` in the request.
         *
         *  If the previous response didn't include a `NextToken` element, there are no more prefetch schedules to get.
         */
        public var nextToken: kotlin.String? = null
        /**
         * Retrieves the prefetch schedule(s) for a specific playback configuration.
         */
        public var playbackConfigurationName: kotlin.String? = null
        /**
         * An optional filtering parameter whereby MediaTailor filters the prefetch schedules to include only specific streams.
         */
        public var streamId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediatailor.model.ListPrefetchSchedulesRequest) : this() {
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.playbackConfigurationName = x.playbackConfigurationName
            this.streamId = x.streamId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediatailor.model.ListPrefetchSchedulesRequest = ListPrefetchSchedulesRequest(this)

        internal fun correctErrors(): Builder {
            if (playbackConfigurationName == null) playbackConfigurationName = ""
            return this
        }
    }
}
