// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediatailor.model



public class ListLiveSourcesRequest private constructor(builder: Builder) {
    /**
     * The maximum number of live sources that you want MediaTailor to return in response to the current request. If there are more than `MaxResults` live sources, use the value of `NextToken` in the response to get the next page of results.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * Pagination token returned by the list request when results exceed the maximum allowed. Use the token to fetch the next page of results.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The name of the source location associated with this Live Sources list.
     */
    public val sourceLocationName: kotlin.String = requireNotNull(builder.sourceLocationName) { "A non-null value must be provided for sourceLocationName" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediatailor.model.ListLiveSourcesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListLiveSourcesRequest(")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("sourceLocationName=$sourceLocationName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = maxResults ?: 0
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (sourceLocationName.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListLiveSourcesRequest

        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (sourceLocationName != other.sourceLocationName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediatailor.model.ListLiveSourcesRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The maximum number of live sources that you want MediaTailor to return in response to the current request. If there are more than `MaxResults` live sources, use the value of `NextToken` in the response to get the next page of results.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * Pagination token returned by the list request when results exceed the maximum allowed. Use the token to fetch the next page of results.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The name of the source location associated with this Live Sources list.
         */
        public var sourceLocationName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediatailor.model.ListLiveSourcesRequest) : this() {
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.sourceLocationName = x.sourceLocationName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediatailor.model.ListLiveSourcesRequest = ListLiveSourcesRequest(this)

        internal fun correctErrors(): Builder {
            if (sourceLocationName == null) sourceLocationName = ""
            return this
        }
    }
}
