// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediatailor.model



/**
 * The configuration for DASH PUT operations.
 */
public class DashConfigurationForPut private constructor(builder: Builder) {
    /**
     * The setting that controls whether MediaTailor includes the Location tag in DASH manifests. MediaTailor populates the Location tag with the URL for manifest update requests, to be used by players that don't support sticky redirects. Disable this if you have CDN routing rules set up for accessing MediaTailor manifests, and you are either using client-side reporting or your players support sticky HTTP redirects. Valid values are `DISABLED` and `EMT_DEFAULT`. The `EMT_DEFAULT` setting enables the inclusion of the tag and is the default value.
     */
    public val mpdLocation: kotlin.String? = builder.mpdLocation
    /**
     * The setting that controls whether MediaTailor handles manifests from the origin server as multi-period manifests or single-period manifests. If your origin server produces single-period manifests, set this to `SINGLE_PERIOD`. The default setting is `MULTI_PERIOD`. For multi-period manifests, omit this setting or set it to `MULTI_PERIOD`.
     */
    public val originManifestType: aws.sdk.kotlin.services.mediatailor.model.OriginManifestType? = builder.originManifestType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediatailor.model.DashConfigurationForPut = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DashConfigurationForPut(")
        append("mpdLocation=$mpdLocation,")
        append("originManifestType=$originManifestType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = mpdLocation?.hashCode() ?: 0
        result = 31 * result + (originManifestType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DashConfigurationForPut

        if (mpdLocation != other.mpdLocation) return false
        if (originManifestType != other.originManifestType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediatailor.model.DashConfigurationForPut = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The setting that controls whether MediaTailor includes the Location tag in DASH manifests. MediaTailor populates the Location tag with the URL for manifest update requests, to be used by players that don't support sticky redirects. Disable this if you have CDN routing rules set up for accessing MediaTailor manifests, and you are either using client-side reporting or your players support sticky HTTP redirects. Valid values are `DISABLED` and `EMT_DEFAULT`. The `EMT_DEFAULT` setting enables the inclusion of the tag and is the default value.
         */
        public var mpdLocation: kotlin.String? = null
        /**
         * The setting that controls whether MediaTailor handles manifests from the origin server as multi-period manifests or single-period manifests. If your origin server produces single-period manifests, set this to `SINGLE_PERIOD`. The default setting is `MULTI_PERIOD`. For multi-period manifests, omit this setting or set it to `MULTI_PERIOD`.
         */
        public var originManifestType: aws.sdk.kotlin.services.mediatailor.model.OriginManifestType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediatailor.model.DashConfigurationForPut) : this() {
            this.mpdLocation = x.mpdLocation
            this.originManifestType = x.originManifestType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediatailor.model.DashConfigurationForPut = DashConfigurationForPut(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
