// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediatailor.model

import aws.smithy.kotlin.runtime.time.Instant

public class CreateSourceLocationResponse private constructor(builder: Builder) {
    /**
     * Access configuration parameters. Configures the type of authentication used to access content from your source location.
     */
    public val accessConfiguration: aws.sdk.kotlin.services.mediatailor.model.AccessConfiguration? = builder.accessConfiguration
    /**
     * The ARN to assign to the source location.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The time the source location was created.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The optional configuration for the server that serves segments.
     */
    public val defaultSegmentDeliveryConfiguration: aws.sdk.kotlin.services.mediatailor.model.DefaultSegmentDeliveryConfiguration? = builder.defaultSegmentDeliveryConfiguration
    /**
     * The source's HTTP package configurations.
     */
    public val httpConfiguration: aws.sdk.kotlin.services.mediatailor.model.HttpConfiguration? = builder.httpConfiguration
    /**
     * The time the source location was last modified.
     */
    public val lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedTime
    /**
     * The segment delivery configurations for the source location. For information about MediaTailor configurations, see [Working with configurations in AWS Elemental MediaTailor](https://docs.aws.amazon.com/mediatailor/latest/ug/configurations.html).
     */
    public val segmentDeliveryConfigurations: List<SegmentDeliveryConfiguration>? = builder.segmentDeliveryConfigurations
    /**
     * The name to assign to the source location.
     */
    public val sourceLocationName: kotlin.String? = builder.sourceLocationName
    /**
     * The tags to assign to the source location. Tags are key-value pairs that you can associate with Amazon resources to help with organization, access control, and cost tracking. For more information, see [Tagging AWS Elemental MediaTailor Resources](https://docs.aws.amazon.com/mediatailor/latest/ug/tagging.html).
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediatailor.model.CreateSourceLocationResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateSourceLocationResponse(")
        append("accessConfiguration=$accessConfiguration,")
        append("arn=$arn,")
        append("creationTime=$creationTime,")
        append("defaultSegmentDeliveryConfiguration=$defaultSegmentDeliveryConfiguration,")
        append("httpConfiguration=$httpConfiguration,")
        append("lastModifiedTime=$lastModifiedTime,")
        append("segmentDeliveryConfigurations=$segmentDeliveryConfigurations,")
        append("sourceLocationName=$sourceLocationName,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessConfiguration?.hashCode() ?: 0
        result = 31 * result + (arn?.hashCode() ?: 0)
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (defaultSegmentDeliveryConfiguration?.hashCode() ?: 0)
        result = 31 * result + (httpConfiguration?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedTime?.hashCode() ?: 0)
        result = 31 * result + (segmentDeliveryConfigurations?.hashCode() ?: 0)
        result = 31 * result + (sourceLocationName?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateSourceLocationResponse

        if (accessConfiguration != other.accessConfiguration) return false
        if (arn != other.arn) return false
        if (creationTime != other.creationTime) return false
        if (defaultSegmentDeliveryConfiguration != other.defaultSegmentDeliveryConfiguration) return false
        if (httpConfiguration != other.httpConfiguration) return false
        if (lastModifiedTime != other.lastModifiedTime) return false
        if (segmentDeliveryConfigurations != other.segmentDeliveryConfigurations) return false
        if (sourceLocationName != other.sourceLocationName) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediatailor.model.CreateSourceLocationResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Access configuration parameters. Configures the type of authentication used to access content from your source location.
         */
        public var accessConfiguration: aws.sdk.kotlin.services.mediatailor.model.AccessConfiguration? = null
        /**
         * The ARN to assign to the source location.
         */
        public var arn: kotlin.String? = null
        /**
         * The time the source location was created.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The optional configuration for the server that serves segments.
         */
        public var defaultSegmentDeliveryConfiguration: aws.sdk.kotlin.services.mediatailor.model.DefaultSegmentDeliveryConfiguration? = null
        /**
         * The source's HTTP package configurations.
         */
        public var httpConfiguration: aws.sdk.kotlin.services.mediatailor.model.HttpConfiguration? = null
        /**
         * The time the source location was last modified.
         */
        public var lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The segment delivery configurations for the source location. For information about MediaTailor configurations, see [Working with configurations in AWS Elemental MediaTailor](https://docs.aws.amazon.com/mediatailor/latest/ug/configurations.html).
         */
        public var segmentDeliveryConfigurations: List<SegmentDeliveryConfiguration>? = null
        /**
         * The name to assign to the source location.
         */
        public var sourceLocationName: kotlin.String? = null
        /**
         * The tags to assign to the source location. Tags are key-value pairs that you can associate with Amazon resources to help with organization, access control, and cost tracking. For more information, see [Tagging AWS Elemental MediaTailor Resources](https://docs.aws.amazon.com/mediatailor/latest/ug/tagging.html).
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediatailor.model.CreateSourceLocationResponse) : this() {
            this.accessConfiguration = x.accessConfiguration
            this.arn = x.arn
            this.creationTime = x.creationTime
            this.defaultSegmentDeliveryConfiguration = x.defaultSegmentDeliveryConfiguration
            this.httpConfiguration = x.httpConfiguration
            this.lastModifiedTime = x.lastModifiedTime
            this.segmentDeliveryConfigurations = x.segmentDeliveryConfigurations
            this.sourceLocationName = x.sourceLocationName
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediatailor.model.CreateSourceLocationResponse = CreateSourceLocationResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.mediatailor.model.AccessConfiguration] inside the given [block]
         */
        public fun accessConfiguration(block: aws.sdk.kotlin.services.mediatailor.model.AccessConfiguration.Builder.() -> kotlin.Unit) {
            this.accessConfiguration = aws.sdk.kotlin.services.mediatailor.model.AccessConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediatailor.model.DefaultSegmentDeliveryConfiguration] inside the given [block]
         */
        public fun defaultSegmentDeliveryConfiguration(block: aws.sdk.kotlin.services.mediatailor.model.DefaultSegmentDeliveryConfiguration.Builder.() -> kotlin.Unit) {
            this.defaultSegmentDeliveryConfiguration = aws.sdk.kotlin.services.mediatailor.model.DefaultSegmentDeliveryConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediatailor.model.HttpConfiguration] inside the given [block]
         */
        public fun httpConfiguration(block: aws.sdk.kotlin.services.mediatailor.model.HttpConfiguration.Builder.() -> kotlin.Unit) {
            this.httpConfiguration = aws.sdk.kotlin.services.mediatailor.model.HttpConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
