// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediatailor.model



public class CreateLiveSourceRequest private constructor(builder: Builder) {
    /**
     * A list of HTTP package configuration parameters for this live source.
     */
    public val httpPackageConfigurations: List<HttpPackageConfiguration> = requireNotNull(builder.httpPackageConfigurations) { "A non-null value must be provided for httpPackageConfigurations" }
    /**
     * The name of the live source.
     */
    public val liveSourceName: kotlin.String = requireNotNull(builder.liveSourceName) { "A non-null value must be provided for liveSourceName" }
    /**
     * The name of the source location.
     */
    public val sourceLocationName: kotlin.String = requireNotNull(builder.sourceLocationName) { "A non-null value must be provided for sourceLocationName" }
    /**
     * The tags to assign to the live source. Tags are key-value pairs that you can associate with Amazon resources to help with organization, access control, and cost tracking. For more information, see [Tagging AWS Elemental MediaTailor Resources](https://docs.aws.amazon.com/mediatailor/latest/ug/tagging.html).
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediatailor.model.CreateLiveSourceRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateLiveSourceRequest(")
        append("httpPackageConfigurations=$httpPackageConfigurations,")
        append("liveSourceName=$liveSourceName,")
        append("sourceLocationName=$sourceLocationName,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = httpPackageConfigurations.hashCode()
        result = 31 * result + (liveSourceName.hashCode())
        result = 31 * result + (sourceLocationName.hashCode())
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateLiveSourceRequest

        if (httpPackageConfigurations != other.httpPackageConfigurations) return false
        if (liveSourceName != other.liveSourceName) return false
        if (sourceLocationName != other.sourceLocationName) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediatailor.model.CreateLiveSourceRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A list of HTTP package configuration parameters for this live source.
         */
        public var httpPackageConfigurations: List<HttpPackageConfiguration>? = null
        /**
         * The name of the live source.
         */
        public var liveSourceName: kotlin.String? = null
        /**
         * The name of the source location.
         */
        public var sourceLocationName: kotlin.String? = null
        /**
         * The tags to assign to the live source. Tags are key-value pairs that you can associate with Amazon resources to help with organization, access control, and cost tracking. For more information, see [Tagging AWS Elemental MediaTailor Resources](https://docs.aws.amazon.com/mediatailor/latest/ug/tagging.html).
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediatailor.model.CreateLiveSourceRequest) : this() {
            this.httpPackageConfigurations = x.httpPackageConfigurations
            this.liveSourceName = x.liveSourceName
            this.sourceLocationName = x.sourceLocationName
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediatailor.model.CreateLiveSourceRequest = CreateLiveSourceRequest(this)

        internal fun correctErrors(): Builder {
            if (httpPackageConfigurations == null) httpPackageConfigurations = emptyList()
            if (liveSourceName == null) liveSourceName = ""
            if (sourceLocationName == null) sourceLocationName = ""
            return this
        }
    }
}
