// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediatailor.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The configuration parameters for a channel. For information about MediaTailor channels, see [Working with channels](https://docs.aws.amazon.com/mediatailor/latest/ug/channel-assembly-channels.html) in the *MediaTailor User Guide*.
 */
public class Channel private constructor(builder: Builder) {
    /**
     * The ARN of the channel.
     */
    public val arn: kotlin.String = requireNotNull(builder.arn) { "A non-null value must be provided for arn" }
    /**
     * The name of the channel.
     */
    public val channelName: kotlin.String = requireNotNull(builder.channelName) { "A non-null value must be provided for channelName" }
    /**
     * Returns the state whether the channel is running or not.
     */
    public val channelState: kotlin.String = requireNotNull(builder.channelState) { "A non-null value must be provided for channelState" }
    /**
     * The timestamp of when the channel was created.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The slate used to fill gaps between programs in the schedule. You must configure filler slate if your channel uses the `LINEAR``PlaybackMode`. MediaTailor doesn't support filler slate for channels using the `LOOP``PlaybackMode`.
     */
    public val fillerSlate: aws.sdk.kotlin.services.mediatailor.model.SlateSource? = builder.fillerSlate
    /**
     * The timestamp of when the channel was last modified.
     */
    public val lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedTime
    /**
     * The log configuration.
     */
    public val logConfiguration: aws.sdk.kotlin.services.mediatailor.model.LogConfigurationForChannel? = builder.logConfiguration
    /**
     * The channel's output properties.
     */
    public val outputs: List<ResponseOutputItem> = requireNotNull(builder.outputs) { "A non-null value must be provided for outputs" }
    /**
     * The type of playback mode for this channel.
     *
     * `LINEAR` - Programs play back-to-back only once.
     *
     * `LOOP` - Programs play back-to-back in an endless loop. When the last program in the schedule plays, playback loops back to the first program in the schedule.
     */
    public val playbackMode: kotlin.String = requireNotNull(builder.playbackMode) { "A non-null value must be provided for playbackMode" }
    /**
     * The tags to assign to the channel. Tags are key-value pairs that you can associate with Amazon resources to help with organization, access control, and cost tracking. For more information, see [Tagging AWS Elemental MediaTailor Resources](https://docs.aws.amazon.com/mediatailor/latest/ug/tagging.html).
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The tier for this channel. STANDARD tier channels can contain live programs.
     */
    public val tier: kotlin.String = requireNotNull(builder.tier) { "A non-null value must be provided for tier" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediatailor.model.Channel = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Channel(")
        append("arn=$arn,")
        append("channelName=$channelName,")
        append("channelState=$channelState,")
        append("creationTime=$creationTime,")
        append("fillerSlate=$fillerSlate,")
        append("lastModifiedTime=$lastModifiedTime,")
        append("logConfiguration=$logConfiguration,")
        append("outputs=$outputs,")
        append("playbackMode=$playbackMode,")
        append("tags=$tags,")
        append("tier=$tier")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn.hashCode()
        result = 31 * result + (channelName.hashCode())
        result = 31 * result + (channelState.hashCode())
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (fillerSlate?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedTime?.hashCode() ?: 0)
        result = 31 * result + (logConfiguration?.hashCode() ?: 0)
        result = 31 * result + (outputs.hashCode())
        result = 31 * result + (playbackMode.hashCode())
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (tier.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Channel

        if (arn != other.arn) return false
        if (channelName != other.channelName) return false
        if (channelState != other.channelState) return false
        if (creationTime != other.creationTime) return false
        if (fillerSlate != other.fillerSlate) return false
        if (lastModifiedTime != other.lastModifiedTime) return false
        if (logConfiguration != other.logConfiguration) return false
        if (outputs != other.outputs) return false
        if (playbackMode != other.playbackMode) return false
        if (tags != other.tags) return false
        if (tier != other.tier) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediatailor.model.Channel = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ARN of the channel.
         */
        public var arn: kotlin.String? = null
        /**
         * The name of the channel.
         */
        public var channelName: kotlin.String? = null
        /**
         * Returns the state whether the channel is running or not.
         */
        public var channelState: kotlin.String? = null
        /**
         * The timestamp of when the channel was created.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The slate used to fill gaps between programs in the schedule. You must configure filler slate if your channel uses the `LINEAR``PlaybackMode`. MediaTailor doesn't support filler slate for channels using the `LOOP``PlaybackMode`.
         */
        public var fillerSlate: aws.sdk.kotlin.services.mediatailor.model.SlateSource? = null
        /**
         * The timestamp of when the channel was last modified.
         */
        public var lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The log configuration.
         */
        public var logConfiguration: aws.sdk.kotlin.services.mediatailor.model.LogConfigurationForChannel? = null
        /**
         * The channel's output properties.
         */
        public var outputs: List<ResponseOutputItem>? = null
        /**
         * The type of playback mode for this channel.
         *
         * `LINEAR` - Programs play back-to-back only once.
         *
         * `LOOP` - Programs play back-to-back in an endless loop. When the last program in the schedule plays, playback loops back to the first program in the schedule.
         */
        public var playbackMode: kotlin.String? = null
        /**
         * The tags to assign to the channel. Tags are key-value pairs that you can associate with Amazon resources to help with organization, access control, and cost tracking. For more information, see [Tagging AWS Elemental MediaTailor Resources](https://docs.aws.amazon.com/mediatailor/latest/ug/tagging.html).
         */
        public var tags: Map<String, String>? = null
        /**
         * The tier for this channel. STANDARD tier channels can contain live programs.
         */
        public var tier: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediatailor.model.Channel) : this() {
            this.arn = x.arn
            this.channelName = x.channelName
            this.channelState = x.channelState
            this.creationTime = x.creationTime
            this.fillerSlate = x.fillerSlate
            this.lastModifiedTime = x.lastModifiedTime
            this.logConfiguration = x.logConfiguration
            this.outputs = x.outputs
            this.playbackMode = x.playbackMode
            this.tags = x.tags
            this.tier = x.tier
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediatailor.model.Channel = Channel(this)

        /**
         * construct an [aws.sdk.kotlin.services.mediatailor.model.SlateSource] inside the given [block]
         */
        public fun fillerSlate(block: aws.sdk.kotlin.services.mediatailor.model.SlateSource.Builder.() -> kotlin.Unit) {
            this.fillerSlate = aws.sdk.kotlin.services.mediatailor.model.SlateSource.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediatailor.model.LogConfigurationForChannel] inside the given [block]
         */
        public fun logConfiguration(block: aws.sdk.kotlin.services.mediatailor.model.LogConfigurationForChannel.Builder.() -> kotlin.Unit) {
            this.logConfiguration = aws.sdk.kotlin.services.mediatailor.model.LogConfigurationForChannel.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (arn == null) arn = ""
            if (channelName == null) channelName = ""
            if (channelState == null) channelState = ""
            if (outputs == null) outputs = emptyList()
            if (playbackMode == null) playbackMode = ""
            if (tier == null) tier = ""
            return this
        }
    }
}
