// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediatailor.model



/**
 * The configuration for avail suppression, also known as ad suppression. For more information about ad suppression, see [Ad Suppression](https://docs.aws.amazon.com/mediatailor/latest/ug/ad-behavior.html).
 */
public class AvailSuppression private constructor(builder: Builder) {
    /**
     * Defines the policy to apply to the avail suppression mode. `BEHIND_LIVE_EDGE` will always use the full avail suppression policy. `AFTER_LIVE_EDGE` mode can be used to invoke partial ad break fills when a session starts mid-break.
     */
    public val fillPolicy: aws.sdk.kotlin.services.mediatailor.model.FillPolicy? = builder.fillPolicy
    /**
     * Sets the ad suppression mode. By default, ad suppression is off and all ad breaks are filled with ads or slate. When Mode is set to `BEHIND_LIVE_EDGE`, ad suppression is active and MediaTailor won't fill ad breaks on or behind the ad suppression Value time in the manifest lookback window. When Mode is set to `AFTER_LIVE_EDGE`, ad suppression is active and MediaTailor won't fill ad breaks that are within the live edge plus the avail suppression value.
     */
    public val mode: aws.sdk.kotlin.services.mediatailor.model.Mode? = builder.mode
    /**
     * A live edge offset time in HH:MM:SS. MediaTailor won't fill ad breaks on or behind this time in the manifest lookback window. If Value is set to 00:00:00, it is in sync with the live edge, and MediaTailor won't fill any ad breaks on or behind the live edge. If you set a Value time, MediaTailor won't fill any ad breaks on or behind this time in the manifest lookback window. For example, if you set 00:45:00, then MediaTailor will fill ad breaks that occur within 45 minutes behind the live edge, but won't fill ad breaks on or behind 45 minutes behind the live edge.
     */
    public val value: kotlin.String? = builder.value

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediatailor.model.AvailSuppression = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AvailSuppression(")
        append("fillPolicy=$fillPolicy,")
        append("mode=$mode,")
        append("value=$value")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = fillPolicy?.hashCode() ?: 0
        result = 31 * result + (mode?.hashCode() ?: 0)
        result = 31 * result + (value?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AvailSuppression

        if (fillPolicy != other.fillPolicy) return false
        if (mode != other.mode) return false
        if (value != other.value) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediatailor.model.AvailSuppression = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Defines the policy to apply to the avail suppression mode. `BEHIND_LIVE_EDGE` will always use the full avail suppression policy. `AFTER_LIVE_EDGE` mode can be used to invoke partial ad break fills when a session starts mid-break.
         */
        public var fillPolicy: aws.sdk.kotlin.services.mediatailor.model.FillPolicy? = null
        /**
         * Sets the ad suppression mode. By default, ad suppression is off and all ad breaks are filled with ads or slate. When Mode is set to `BEHIND_LIVE_EDGE`, ad suppression is active and MediaTailor won't fill ad breaks on or behind the ad suppression Value time in the manifest lookback window. When Mode is set to `AFTER_LIVE_EDGE`, ad suppression is active and MediaTailor won't fill ad breaks that are within the live edge plus the avail suppression value.
         */
        public var mode: aws.sdk.kotlin.services.mediatailor.model.Mode? = null
        /**
         * A live edge offset time in HH:MM:SS. MediaTailor won't fill ad breaks on or behind this time in the manifest lookback window. If Value is set to 00:00:00, it is in sync with the live edge, and MediaTailor won't fill any ad breaks on or behind the live edge. If you set a Value time, MediaTailor won't fill any ad breaks on or behind this time in the manifest lookback window. For example, if you set 00:45:00, then MediaTailor will fill ad breaks that occur within 45 minutes behind the live edge, but won't fill ad breaks on or behind 45 minutes behind the live edge.
         */
        public var value: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediatailor.model.AvailSuppression) : this() {
            this.fillPolicy = x.fillPolicy
            this.mode = x.mode
            this.value = x.value
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediatailor.model.AvailSuppression = AvailSuppression(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
