// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediatailor.model



/**
 * Ad break configuration parameters.
 */
public class AdBreak private constructor(builder: Builder) {
    /**
     * Defines a list of key/value pairs that MediaTailor generates within the `EXT-X-ASSET`tag for `SCTE35_ENHANCED` output.
     */
    public val adBreakMetadata: List<KeyValuePair>? = builder.adBreakMetadata
    /**
     * The SCTE-35 ad insertion type. Accepted value: `SPLICE_INSERT`, `TIME_SIGNAL`.
     */
    public val messageType: aws.sdk.kotlin.services.mediatailor.model.MessageType? = builder.messageType
    /**
     * How long (in milliseconds) after the beginning of the program that an ad starts. This value must fall within 100ms of a segment boundary, otherwise the ad break will be skipped.
     */
    public val offsetMillis: kotlin.Long = builder.offsetMillis
    /**
     * Ad break slate configuration.
     */
    public val slate: aws.sdk.kotlin.services.mediatailor.model.SlateSource? = builder.slate
    /**
     * This defines the SCTE-35 `splice_insert()` message inserted around the ad. For information about using `splice_insert()`, see the SCTE-35 specficiaiton, section 9.7.3.1.
     */
    public val spliceInsertMessage: aws.sdk.kotlin.services.mediatailor.model.SpliceInsertMessage? = builder.spliceInsertMessage
    /**
     * Defines the SCTE-35 `time_signal` message inserted around the ad.
     *
     * Programs on a channel's schedule can be configured with one or more ad breaks. You can attach a `splice_insert` SCTE-35 message to the ad break. This message provides basic metadata about the ad break.
     *
     * See section 9.7.4 of the 2022 SCTE-35 specification for more information.
     */
    public val timeSignalMessage: aws.sdk.kotlin.services.mediatailor.model.TimeSignalMessage? = builder.timeSignalMessage

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediatailor.model.AdBreak = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AdBreak(")
        append("adBreakMetadata=$adBreakMetadata,")
        append("messageType=$messageType,")
        append("offsetMillis=$offsetMillis,")
        append("slate=$slate,")
        append("spliceInsertMessage=$spliceInsertMessage,")
        append("timeSignalMessage=$timeSignalMessage")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = adBreakMetadata?.hashCode() ?: 0
        result = 31 * result + (messageType?.hashCode() ?: 0)
        result = 31 * result + (offsetMillis.hashCode())
        result = 31 * result + (slate?.hashCode() ?: 0)
        result = 31 * result + (spliceInsertMessage?.hashCode() ?: 0)
        result = 31 * result + (timeSignalMessage?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AdBreak

        if (adBreakMetadata != other.adBreakMetadata) return false
        if (messageType != other.messageType) return false
        if (offsetMillis != other.offsetMillis) return false
        if (slate != other.slate) return false
        if (spliceInsertMessage != other.spliceInsertMessage) return false
        if (timeSignalMessage != other.timeSignalMessage) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediatailor.model.AdBreak = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Defines a list of key/value pairs that MediaTailor generates within the `EXT-X-ASSET`tag for `SCTE35_ENHANCED` output.
         */
        public var adBreakMetadata: List<KeyValuePair>? = null
        /**
         * The SCTE-35 ad insertion type. Accepted value: `SPLICE_INSERT`, `TIME_SIGNAL`.
         */
        public var messageType: aws.sdk.kotlin.services.mediatailor.model.MessageType? = null
        /**
         * How long (in milliseconds) after the beginning of the program that an ad starts. This value must fall within 100ms of a segment boundary, otherwise the ad break will be skipped.
         */
        public var offsetMillis: kotlin.Long = 0L
        /**
         * Ad break slate configuration.
         */
        public var slate: aws.sdk.kotlin.services.mediatailor.model.SlateSource? = null
        /**
         * This defines the SCTE-35 `splice_insert()` message inserted around the ad. For information about using `splice_insert()`, see the SCTE-35 specficiaiton, section 9.7.3.1.
         */
        public var spliceInsertMessage: aws.sdk.kotlin.services.mediatailor.model.SpliceInsertMessage? = null
        /**
         * Defines the SCTE-35 `time_signal` message inserted around the ad.
         *
         * Programs on a channel's schedule can be configured with one or more ad breaks. You can attach a `splice_insert` SCTE-35 message to the ad break. This message provides basic metadata about the ad break.
         *
         * See section 9.7.4 of the 2022 SCTE-35 specification for more information.
         */
        public var timeSignalMessage: aws.sdk.kotlin.services.mediatailor.model.TimeSignalMessage? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediatailor.model.AdBreak) : this() {
            this.adBreakMetadata = x.adBreakMetadata
            this.messageType = x.messageType
            this.offsetMillis = x.offsetMillis
            this.slate = x.slate
            this.spliceInsertMessage = x.spliceInsertMessage
            this.timeSignalMessage = x.timeSignalMessage
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediatailor.model.AdBreak = AdBreak(this)

        /**
         * construct an [aws.sdk.kotlin.services.mediatailor.model.SlateSource] inside the given [block]
         */
        public fun slate(block: aws.sdk.kotlin.services.mediatailor.model.SlateSource.Builder.() -> kotlin.Unit) {
            this.slate = aws.sdk.kotlin.services.mediatailor.model.SlateSource.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediatailor.model.SpliceInsertMessage] inside the given [block]
         */
        public fun spliceInsertMessage(block: aws.sdk.kotlin.services.mediatailor.model.SpliceInsertMessage.Builder.() -> kotlin.Unit) {
            this.spliceInsertMessage = aws.sdk.kotlin.services.mediatailor.model.SpliceInsertMessage.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediatailor.model.TimeSignalMessage] inside the given [block]
         */
        public fun timeSignalMessage(block: aws.sdk.kotlin.services.mediatailor.model.TimeSignalMessage.Builder.() -> kotlin.Unit) {
            this.timeSignalMessage = aws.sdk.kotlin.services.mediatailor.model.TimeSignalMessage.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
