// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediatailor.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.mediatailor.model.AvailSuppression
import aws.sdk.kotlin.services.mediatailor.model.Bumper
import aws.sdk.kotlin.services.mediatailor.model.CdnConfiguration
import aws.sdk.kotlin.services.mediatailor.model.DashConfiguration
import aws.sdk.kotlin.services.mediatailor.model.HlsConfiguration
import aws.sdk.kotlin.services.mediatailor.model.LivePreRollConfiguration
import aws.sdk.kotlin.services.mediatailor.model.LogConfiguration
import aws.sdk.kotlin.services.mediatailor.model.ManifestProcessingRules
import aws.sdk.kotlin.services.mediatailor.model.MediaTailorException
import aws.sdk.kotlin.services.mediatailor.model.PutPlaybackConfigurationResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class PutPlaybackConfigurationOperationDeserializer: HttpDeserialize<PutPlaybackConfigurationResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): PutPlaybackConfigurationResponse {
        if (!response.status.isSuccess()) {
            throwPutPlaybackConfigurationError(context, response)
        }
        val builder = PutPlaybackConfigurationResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializePutPlaybackConfigurationOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwPutPlaybackConfigurationError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw MediaTailorException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        else -> MediaTailorException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializePutPlaybackConfigurationOperationBody(builder: PutPlaybackConfigurationResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ADDECISIONSERVERURL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("AdDecisionServerUrl"))
    val AVAILSUPPRESSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("AvailSuppression"))
    val BUMPER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Bumper"))
    val CDNCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("CdnConfiguration"))
    val CONFIGURATIONALIASES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("ConfigurationAliases"))
    val CONFIGURATIONALIASES_C0_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map)
    val DASHCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("DashConfiguration"))
    val HLSCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("HlsConfiguration"))
    val LIVEPREROLLCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("LivePreRollConfiguration"))
    val LOGCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("LogConfiguration"))
    val MANIFESTPROCESSINGRULES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ManifestProcessingRules"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Name"))
    val PERSONALIZATIONTHRESHOLDSECONDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("PersonalizationThresholdSeconds"))
    val PLAYBACKCONFIGURATIONARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("PlaybackConfigurationArn"))
    val PLAYBACKENDPOINTPREFIX_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("PlaybackEndpointPrefix"))
    val SESSIONINITIALIZATIONENDPOINTPREFIX_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SessionInitializationEndpointPrefix"))
    val SLATEADURL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SlateAdUrl"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("tags"))
    val TRANSCODEPROFILENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("TranscodeProfileName"))
    val VIDEOCONTENTSOURCEURL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("VideoContentSourceUrl"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ADDECISIONSERVERURL_DESCRIPTOR)
        field(AVAILSUPPRESSION_DESCRIPTOR)
        field(BUMPER_DESCRIPTOR)
        field(CDNCONFIGURATION_DESCRIPTOR)
        field(CONFIGURATIONALIASES_DESCRIPTOR)
        field(DASHCONFIGURATION_DESCRIPTOR)
        field(HLSCONFIGURATION_DESCRIPTOR)
        field(LIVEPREROLLCONFIGURATION_DESCRIPTOR)
        field(LOGCONFIGURATION_DESCRIPTOR)
        field(MANIFESTPROCESSINGRULES_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(PERSONALIZATIONTHRESHOLDSECONDS_DESCRIPTOR)
        field(PLAYBACKCONFIGURATIONARN_DESCRIPTOR)
        field(PLAYBACKENDPOINTPREFIX_DESCRIPTOR)
        field(SESSIONINITIALIZATIONENDPOINTPREFIX_DESCRIPTOR)
        field(SLATEADURL_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(TRANSCODEPROFILENAME_DESCRIPTOR)
        field(VIDEOCONTENTSOURCEURL_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ADDECISIONSERVERURL_DESCRIPTOR.index -> builder.adDecisionServerUrl = deserializeString()
                AVAILSUPPRESSION_DESCRIPTOR.index -> builder.availSuppression = deserializeAvailSuppressionDocument(deserializer)
                BUMPER_DESCRIPTOR.index -> builder.bumper = deserializeBumperDocument(deserializer)
                CDNCONFIGURATION_DESCRIPTOR.index -> builder.cdnConfiguration = deserializeCdnConfigurationDocument(deserializer)
                CONFIGURATIONALIASES_DESCRIPTOR.index -> builder.configurationAliases =
                    deserializer.deserializeMap(CONFIGURATIONALIASES_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, Map<String, String>>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 =
                                if (nextHasValue()) {
                                    deserializer.deserializeMap(CONFIGURATIONALIASES_C0_DESCRIPTOR) {
                                        val map1 = mutableMapOf<String, String>()
                                        while (hasNextEntry()) {
                                            val k1 = key()
                                            val v1 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                                            map1[k1] = v1
                                        }
                                        map1
                                    }
                                } else { deserializeNull(); continue }

                            map0[k0] = v0
                        }
                        map0
                    }
                DASHCONFIGURATION_DESCRIPTOR.index -> builder.dashConfiguration = deserializeDashConfigurationDocument(deserializer)
                HLSCONFIGURATION_DESCRIPTOR.index -> builder.hlsConfiguration = deserializeHlsConfigurationDocument(deserializer)
                LIVEPREROLLCONFIGURATION_DESCRIPTOR.index -> builder.livePreRollConfiguration = deserializeLivePreRollConfigurationDocument(deserializer)
                LOGCONFIGURATION_DESCRIPTOR.index -> builder.logConfiguration = deserializeLogConfigurationDocument(deserializer)
                MANIFESTPROCESSINGRULES_DESCRIPTOR.index -> builder.manifestProcessingRules = deserializeManifestProcessingRulesDocument(deserializer)
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                PERSONALIZATIONTHRESHOLDSECONDS_DESCRIPTOR.index -> builder.personalizationThresholdSeconds = deserializeInt()
                PLAYBACKCONFIGURATIONARN_DESCRIPTOR.index -> builder.playbackConfigurationArn = deserializeString()
                PLAYBACKENDPOINTPREFIX_DESCRIPTOR.index -> builder.playbackEndpointPrefix = deserializeString()
                SESSIONINITIALIZATIONENDPOINTPREFIX_DESCRIPTOR.index -> builder.sessionInitializationEndpointPrefix = deserializeString()
                SLATEADURL_DESCRIPTOR.index -> builder.slateAdUrl = deserializeString()
                TAGS_DESCRIPTOR.index -> builder.tags =
                    deserializer.deserializeMap(TAGS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                TRANSCODEPROFILENAME_DESCRIPTOR.index -> builder.transcodeProfileName = deserializeString()
                VIDEOCONTENTSOURCEURL_DESCRIPTOR.index -> builder.videoContentSourceUrl = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
