// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediatailor.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.mediatailor.model.GetPrefetchScheduleResponse
import aws.sdk.kotlin.services.mediatailor.model.MediaTailorException
import aws.sdk.kotlin.services.mediatailor.model.PrefetchConsumption
import aws.sdk.kotlin.services.mediatailor.model.PrefetchRetrieval
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetPrefetchScheduleOperationDeserializer: HttpDeserialize<GetPrefetchScheduleResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetPrefetchScheduleResponse {
        if (!response.status.isSuccess()) {
            throwGetPrefetchScheduleError(context, response)
        }
        val builder = GetPrefetchScheduleResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetPrefetchScheduleOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetPrefetchScheduleError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw MediaTailorException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        else -> MediaTailorException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetPrefetchScheduleOperationBody(builder: GetPrefetchScheduleResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Arn"))
    val CONSUMPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Consumption"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Name"))
    val PLAYBACKCONFIGURATIONNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("PlaybackConfigurationName"))
    val RETRIEVAL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Retrieval"))
    val STREAMID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("StreamId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ARN_DESCRIPTOR)
        field(CONSUMPTION_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(PLAYBACKCONFIGURATIONNAME_DESCRIPTOR)
        field(RETRIEVAL_DESCRIPTOR)
        field(STREAMID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ARN_DESCRIPTOR.index -> builder.arn = deserializeString()
                CONSUMPTION_DESCRIPTOR.index -> builder.consumption = deserializePrefetchConsumptionDocument(deserializer)
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                PLAYBACKCONFIGURATIONNAME_DESCRIPTOR.index -> builder.playbackConfigurationName = deserializeString()
                RETRIEVAL_DESCRIPTOR.index -> builder.retrieval = deserializePrefetchRetrievalDocument(deserializer)
                STREAMID_DESCRIPTOR.index -> builder.streamId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
