// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediatailor.transform

import aws.sdk.kotlin.services.mediatailor.model.AccessConfiguration
import aws.sdk.kotlin.services.mediatailor.model.CreateSourceLocationRequest
import aws.sdk.kotlin.services.mediatailor.model.DefaultSegmentDeliveryConfiguration
import aws.sdk.kotlin.services.mediatailor.model.HttpConfiguration
import aws.sdk.kotlin.services.mediatailor.model.SegmentDeliveryConfiguration
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateSourceLocationOperationSerializer: HttpSerialize<CreateSourceLocationRequest> {
    override suspend fun serialize(context: ExecutionContext, input: CreateSourceLocationRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            val pathSegments = listOf(
                "sourceLocation",
                "${input.sourceLocationName}".encodeLabel(),
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializeCreateSourceLocationOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCreateSourceLocationOperationBody(context: ExecutionContext, input: CreateSourceLocationRequest): ByteArray {
    val serializer = JsonSerializer()
    val ACCESSCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("AccessConfiguration"))
    val DEFAULTSEGMENTDELIVERYCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("DefaultSegmentDeliveryConfiguration"))
    val HTTPCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("HttpConfiguration"))
    val SEGMENTDELIVERYCONFIGURATIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("SegmentDeliveryConfigurations"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("tags"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ACCESSCONFIGURATION_DESCRIPTOR)
        field(DEFAULTSEGMENTDELIVERYCONFIGURATION_DESCRIPTOR)
        field(HTTPCONFIGURATION_DESCRIPTOR)
        field(SEGMENTDELIVERYCONFIGURATIONS_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.accessConfiguration?.let { field(ACCESSCONFIGURATION_DESCRIPTOR, it, ::serializeAccessConfigurationDocument) }
        input.defaultSegmentDeliveryConfiguration?.let { field(DEFAULTSEGMENTDELIVERYCONFIGURATION_DESCRIPTOR, it, ::serializeDefaultSegmentDeliveryConfigurationDocument) }
        input.httpConfiguration?.let { field(HTTPCONFIGURATION_DESCRIPTOR, it, ::serializeHttpConfigurationDocument) }
        if (input.segmentDeliveryConfigurations != null) {
            listField(SEGMENTDELIVERYCONFIGURATIONS_DESCRIPTOR) {
                for (el0 in input.segmentDeliveryConfigurations) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeSegmentDeliveryConfigurationDocument))
                }
            }
        }
        if (input.tags != null) {
            mapField(TAGS_DESCRIPTOR) {
                input.tags.forEach { (key, value) -> entry(key, value) }
            }
        }
    }
    return serializer.toByteArray()
}
