// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediatailor.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * VOD source configuration parameters.
 */
class VodSource private constructor(builder: Builder) {
    /**
     * The ARN for the VOD source.
     */
    val arn: kotlin.String? = builder.arn
    /**
     * The timestamp that indicates when the VOD source was created.
     */
    val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The HTTP package configurations for the VOD source.
     */
    val httpPackageConfigurations: List<HttpPackageConfiguration>? = builder.httpPackageConfigurations
    /**
     * The timestamp that indicates when the VOD source was last modified.
     */
    val lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedTime
    /**
     * The name of the source location that the VOD source is associated with.
     */
    val sourceLocationName: kotlin.String? = builder.sourceLocationName
    /**
     * The tags assigned to the VOD source.
     */
    val tags: Map<String, String>? = builder.tags
    /**
     * The name of the VOD source.
     */
    val vodSourceName: kotlin.String? = builder.vodSourceName

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediatailor.model.VodSource = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("VodSource(")
        append("arn=$arn,")
        append("creationTime=$creationTime,")
        append("httpPackageConfigurations=$httpPackageConfigurations,")
        append("lastModifiedTime=$lastModifiedTime,")
        append("sourceLocationName=$sourceLocationName,")
        append("tags=$tags,")
        append("vodSourceName=$vodSourceName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (httpPackageConfigurations?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedTime?.hashCode() ?: 0)
        result = 31 * result + (sourceLocationName?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (vodSourceName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as VodSource

        if (arn != other.arn) return false
        if (creationTime != other.creationTime) return false
        if (httpPackageConfigurations != other.httpPackageConfigurations) return false
        if (lastModifiedTime != other.lastModifiedTime) return false
        if (sourceLocationName != other.sourceLocationName) return false
        if (tags != other.tags) return false
        if (vodSourceName != other.vodSourceName) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediatailor.model.VodSource = Builder(this).apply(block).build()

    class Builder {
        /**
         * The ARN for the VOD source.
         */
        var arn: kotlin.String? = null
        /**
         * The timestamp that indicates when the VOD source was created.
         */
        var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The HTTP package configurations for the VOD source.
         */
        var httpPackageConfigurations: List<HttpPackageConfiguration>? = null
        /**
         * The timestamp that indicates when the VOD source was last modified.
         */
        var lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the source location that the VOD source is associated with.
         */
        var sourceLocationName: kotlin.String? = null
        /**
         * The tags assigned to the VOD source.
         */
        var tags: Map<String, String>? = null
        /**
         * The name of the VOD source.
         */
        var vodSourceName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediatailor.model.VodSource) : this() {
            this.arn = x.arn
            this.creationTime = x.creationTime
            this.httpPackageConfigurations = x.httpPackageConfigurations
            this.lastModifiedTime = x.lastModifiedTime
            this.sourceLocationName = x.sourceLocationName
            this.tags = x.tags
            this.vodSourceName = x.vodSourceName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediatailor.model.VodSource = VodSource(this)
    }
}
