// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediatailor.model



/**
 * Program transition configuration.
 */
class Transition private constructor(builder: Builder) {
    /**
     * The duration of the live program in seconds.
     */
    val durationMillis: kotlin.Long? = builder.durationMillis
    /**
     * The position where this program will be inserted relative to the RelativePosition.
     */
    val relativePosition: aws.sdk.kotlin.services.mediatailor.model.RelativePosition? = builder.relativePosition
    /**
     * The name of the program that this program will be inserted next to, as defined by RelativePosition.
     */
    val relativeProgram: kotlin.String? = builder.relativeProgram
    /**
     * The date and time that the program is scheduled to start, in epoch milliseconds.
     */
    val scheduledStartTimeMillis: kotlin.Long? = builder.scheduledStartTimeMillis
    /**
     * Defines when the program plays in the schedule. You can set the value to ABSOLUTE or RELATIVE.
     *
     * ABSOLUTE - The program plays at a specific wall clock time. This setting can only be used for channels using the LINEAR PlaybackMode.
     *
     * Note the following considerations when using ABSOLUTE transitions:
     *
     * If the preceding program in the schedule has a duration that extends past the wall clock time, MediaTailor truncates the preceding program on a common segment boundary.
     *
     * If there are gaps in playback, MediaTailor plays the FillerSlate you configured for your linear channel.
     *
     * RELATIVE - The program is inserted into the schedule either before or after a program that you specify via RelativePosition.
     */
    val type: kotlin.String? = builder.type

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediatailor.model.Transition = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Transition(")
        append("durationMillis=$durationMillis,")
        append("relativePosition=$relativePosition,")
        append("relativeProgram=$relativeProgram,")
        append("scheduledStartTimeMillis=$scheduledStartTimeMillis,")
        append("type=$type)")
    }

    override fun hashCode(): kotlin.Int {
        var result = durationMillis?.hashCode() ?: 0
        result = 31 * result + (relativePosition?.hashCode() ?: 0)
        result = 31 * result + (relativeProgram?.hashCode() ?: 0)
        result = 31 * result + (scheduledStartTimeMillis?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Transition

        if (durationMillis != other.durationMillis) return false
        if (relativePosition != other.relativePosition) return false
        if (relativeProgram != other.relativeProgram) return false
        if (scheduledStartTimeMillis != other.scheduledStartTimeMillis) return false
        if (type != other.type) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediatailor.model.Transition = Builder(this).apply(block).build()

    class Builder {
        /**
         * The duration of the live program in seconds.
         */
        var durationMillis: kotlin.Long? = null
        /**
         * The position where this program will be inserted relative to the RelativePosition.
         */
        var relativePosition: aws.sdk.kotlin.services.mediatailor.model.RelativePosition? = null
        /**
         * The name of the program that this program will be inserted next to, as defined by RelativePosition.
         */
        var relativeProgram: kotlin.String? = null
        /**
         * The date and time that the program is scheduled to start, in epoch milliseconds.
         */
        var scheduledStartTimeMillis: kotlin.Long? = null
        /**
         * Defines when the program plays in the schedule. You can set the value to ABSOLUTE or RELATIVE.
         *
         * ABSOLUTE - The program plays at a specific wall clock time. This setting can only be used for channels using the LINEAR PlaybackMode.
         *
         * Note the following considerations when using ABSOLUTE transitions:
         *
         * If the preceding program in the schedule has a duration that extends past the wall clock time, MediaTailor truncates the preceding program on a common segment boundary.
         *
         * If there are gaps in playback, MediaTailor plays the FillerSlate you configured for your linear channel.
         *
         * RELATIVE - The program is inserted into the schedule either before or after a program that you specify via RelativePosition.
         */
        var type: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediatailor.model.Transition) : this() {
            this.durationMillis = x.durationMillis
            this.relativePosition = x.relativePosition
            this.relativeProgram = x.relativeProgram
            this.scheduledStartTimeMillis = x.scheduledStartTimeMillis
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediatailor.model.Transition = Transition(this)
    }
}
