// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediatailor.model



/**
 * The configuration for pre-roll ad insertion.
 */
class LivePreRollConfiguration private constructor(builder: Builder) {
    /**
     * The URL for the ad decision server (ADS) for pre-roll ads. This includes the specification of static parameters and placeholders for dynamic parameters. AWS Elemental MediaTailor substitutes player-specific and session-specific parameters as needed when calling the ADS. Alternately, for testing, you can provide a static VAST URL. The maximum length is 25,000 characters.
     */
    val adDecisionServerUrl: kotlin.String? = builder.adDecisionServerUrl
    /**
     * The maximum allowed duration for the pre-roll ad avail. AWS Elemental MediaTailor won't play pre-roll ads to exceed this duration, regardless of the total duration of ads that the ADS returns.
     */
    val maxDurationSeconds: kotlin.Int? = builder.maxDurationSeconds

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediatailor.model.LivePreRollConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LivePreRollConfiguration(")
        append("adDecisionServerUrl=$adDecisionServerUrl,")
        append("maxDurationSeconds=$maxDurationSeconds)")
    }

    override fun hashCode(): kotlin.Int {
        var result = adDecisionServerUrl?.hashCode() ?: 0
        result = 31 * result + (maxDurationSeconds ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LivePreRollConfiguration

        if (adDecisionServerUrl != other.adDecisionServerUrl) return false
        if (maxDurationSeconds != other.maxDurationSeconds) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediatailor.model.LivePreRollConfiguration = Builder(this).apply(block).build()

    class Builder {
        /**
         * The URL for the ad decision server (ADS) for pre-roll ads. This includes the specification of static parameters and placeholders for dynamic parameters. AWS Elemental MediaTailor substitutes player-specific and session-specific parameters as needed when calling the ADS. Alternately, for testing, you can provide a static VAST URL. The maximum length is 25,000 characters.
         */
        var adDecisionServerUrl: kotlin.String? = null
        /**
         * The maximum allowed duration for the pre-roll ad avail. AWS Elemental MediaTailor won't play pre-roll ads to exceed this duration, regardless of the total duration of ads that the ADS returns.
         */
        var maxDurationSeconds: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediatailor.model.LivePreRollConfiguration) : this() {
            this.adDecisionServerUrl = x.adDecisionServerUrl
            this.maxDurationSeconds = x.maxDurationSeconds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediatailor.model.LivePreRollConfiguration = LivePreRollConfiguration(this)
    }
}
