// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediatailor.model



/**
 * The configuration for using a content delivery network (CDN), like Amazon CloudFront, for content and ad segment management.
 */
class CdnConfiguration private constructor(builder: Builder) {
    /**
     * A non-default content delivery network (CDN) to serve ad segments. By default, AWS Elemental MediaTailor uses Amazon CloudFront with default cache settings as its CDN for ad segments. To set up an alternate CDN, create a rule in your CDN for the origin ads.mediatailor.&lt;region>.amazonaws.com. Then specify the rule's name in this AdSegmentUrlPrefix. When AWS Elemental MediaTailor serves a manifest, it reports your CDN as the source for ad segments.
     */
    val adSegmentUrlPrefix: kotlin.String? = builder.adSegmentUrlPrefix
    /**
     * A content delivery network (CDN) to cache content segments, so that content requests don’t always have to go to the origin server. First, create a rule in your CDN for the content segment origin server. Then specify the rule's name in this ContentSegmentUrlPrefix. When AWS Elemental MediaTailor serves a manifest, it reports your CDN as the source for content segments.
     */
    val contentSegmentUrlPrefix: kotlin.String? = builder.contentSegmentUrlPrefix

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediatailor.model.CdnConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CdnConfiguration(")
        append("adSegmentUrlPrefix=$adSegmentUrlPrefix,")
        append("contentSegmentUrlPrefix=$contentSegmentUrlPrefix)")
    }

    override fun hashCode(): kotlin.Int {
        var result = adSegmentUrlPrefix?.hashCode() ?: 0
        result = 31 * result + (contentSegmentUrlPrefix?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CdnConfiguration

        if (adSegmentUrlPrefix != other.adSegmentUrlPrefix) return false
        if (contentSegmentUrlPrefix != other.contentSegmentUrlPrefix) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediatailor.model.CdnConfiguration = Builder(this).apply(block).build()

    class Builder {
        /**
         * A non-default content delivery network (CDN) to serve ad segments. By default, AWS Elemental MediaTailor uses Amazon CloudFront with default cache settings as its CDN for ad segments. To set up an alternate CDN, create a rule in your CDN for the origin ads.mediatailor.&lt;region>.amazonaws.com. Then specify the rule's name in this AdSegmentUrlPrefix. When AWS Elemental MediaTailor serves a manifest, it reports your CDN as the source for ad segments.
         */
        var adSegmentUrlPrefix: kotlin.String? = null
        /**
         * A content delivery network (CDN) to cache content segments, so that content requests don’t always have to go to the origin server. First, create a rule in your CDN for the content segment origin server. Then specify the rule's name in this ContentSegmentUrlPrefix. When AWS Elemental MediaTailor serves a manifest, it reports your CDN as the source for content segments.
         */
        var contentSegmentUrlPrefix: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediatailor.model.CdnConfiguration) : this() {
            this.adSegmentUrlPrefix = x.adSegmentUrlPrefix
            this.contentSegmentUrlPrefix = x.contentSegmentUrlPrefix
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediatailor.model.CdnConfiguration = CdnConfiguration(this)
    }
}
