// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediatailor

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.mediatailor.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.mediatailor.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * Use the AWS Elemental MediaTailor SDKs and CLI to configure scalable ad insertion and linear channels. With MediaTailor, you can assemble existing content into a linear stream and serve targeted ads to viewers while maintaining broadcast quality in over-the-top (OTT) video applications. For information about using the service, including detailed information about the settings covered in this guide, see the [AWS Elemental MediaTailor User Guide](https://docs.aws.amazon.com/mediatailor/latest/ug/).
 *
 * Through the SDKs and the CLI you manage AWS Elemental MediaTailor configurations and channels the same as you do through the console. For example, you specify ad insertion behavior and mapping information for the origin server and the ad decision server (ADS).
 */
interface MediaTailorClient : SdkClient {

    override val serviceName: String
        get() = "MediaTailor"
    /**
     * MediaTailorClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(block: Config.Builder.() -> Unit): MediaTailorClient {
            val config = Config.Builder().apply(block).build()
            return DefaultMediaTailorClient(config)
        }

        operator fun invoke(config: Config): MediaTailorClient = DefaultMediaTailorClient(config)

        /**
         * Construct a [MediaTailorClient] by resolving the configuration from the current environment.
         */
        suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): MediaTailorClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            return DefaultMediaTailorClient(builder.build())
        }
    }

    class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig {
        val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        val retryStrategy: RetryStrategy = StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        companion object {
            inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Configures Amazon CloudWatch log settings for a playback configuration.
     */
    suspend fun configureLogsForPlaybackConfiguration(input: ConfigureLogsForPlaybackConfigurationRequest): ConfigureLogsForPlaybackConfigurationResponse

    /**
     * Creates a channel.
     */
    suspend fun createChannel(input: CreateChannelRequest): CreateChannelResponse

    /**
     * Creates name for a specific live source in a source location.
     */
    suspend fun createLiveSource(input: CreateLiveSourceRequest): CreateLiveSourceResponse

    /**
     * Creates a new prefetch schedule for the specified playback configuration.
     */
    suspend fun createPrefetchSchedule(input: CreatePrefetchScheduleRequest): CreatePrefetchScheduleResponse

    /**
     * Creates a program.
     */
    suspend fun createProgram(input: CreateProgramRequest): CreateProgramResponse

    /**
     * Creates a source location on a specific channel.
     */
    suspend fun createSourceLocation(input: CreateSourceLocationRequest): CreateSourceLocationResponse

    /**
     * Creates name for a specific VOD source in a source location.
     */
    suspend fun createVodSource(input: CreateVodSourceRequest): CreateVodSourceResponse

    /**
     * Deletes a channel. You must stop the channel before it can be deleted.
     */
    suspend fun deleteChannel(input: DeleteChannelRequest): DeleteChannelResponse

    /**
     * Deletes a channel's IAM policy.
     */
    suspend fun deleteChannelPolicy(input: DeleteChannelPolicyRequest): DeleteChannelPolicyResponse

    /**
     * Deletes a specific live source in a specific source location.
     */
    suspend fun deleteLiveSource(input: DeleteLiveSourceRequest): DeleteLiveSourceResponse

    /**
     * Deletes the playback configuration for the specified name.
     */
    suspend fun deletePlaybackConfiguration(input: DeletePlaybackConfigurationRequest): DeletePlaybackConfigurationResponse

    /**
     * Deletes a prefetch schedule for a specific playback configuration. If you call DeletePrefetchSchedule on an expired prefetch schedule, MediaTailor returns an HTTP 404 status code.
     */
    suspend fun deletePrefetchSchedule(input: DeletePrefetchScheduleRequest): DeletePrefetchScheduleResponse

    /**
     * Deletes a specific program on a specific channel.
     */
    suspend fun deleteProgram(input: DeleteProgramRequest): DeleteProgramResponse

    /**
     * Deletes a source location on a specific channel.
     */
    suspend fun deleteSourceLocation(input: DeleteSourceLocationRequest): DeleteSourceLocationResponse

    /**
     * Deletes a specific VOD source in a specific source location.
     */
    suspend fun deleteVodSource(input: DeleteVodSourceRequest): DeleteVodSourceResponse

    /**
     * Describes the properties of a specific channel.
     */
    suspend fun describeChannel(input: DescribeChannelRequest): DescribeChannelResponse

    /**
     * Provides details about a specific live source in a specific source location.
     */
    suspend fun describeLiveSource(input: DescribeLiveSourceRequest): DescribeLiveSourceResponse

    /**
     * Retrieves the properties of the requested program.
     */
    suspend fun describeProgram(input: DescribeProgramRequest): DescribeProgramResponse

    /**
     * Retrieves the properties of the requested source location.
     */
    suspend fun describeSourceLocation(input: DescribeSourceLocationRequest): DescribeSourceLocationResponse

    /**
     * Provides details about a specific VOD source in a specific source location.
     */
    suspend fun describeVodSource(input: DescribeVodSourceRequest): DescribeVodSourceResponse

    /**
     * Retrieves information about a channel's IAM policy.
     */
    suspend fun getChannelPolicy(input: GetChannelPolicyRequest): GetChannelPolicyResponse

    /**
     * Retrieves information about your channel's schedule.
     */
    suspend fun getChannelSchedule(input: GetChannelScheduleRequest): GetChannelScheduleResponse

    /**
     * Returns the playback configuration for the specified name.
     */
    suspend fun getPlaybackConfiguration(input: GetPlaybackConfigurationRequest): GetPlaybackConfigurationResponse

    /**
     * Returns information about the prefetch schedule for a specific playback configuration. If you call GetPrefetchSchedule on an expired prefetch schedule, MediaTailor returns an HTTP 404 status code.
     */
    suspend fun getPrefetchSchedule(input: GetPrefetchScheduleRequest): GetPrefetchScheduleResponse

    /**
     * Returns a list of alerts for the given resource.
     */
    suspend fun listAlerts(input: ListAlertsRequest): ListAlertsResponse

    /**
     * Retrieves a list of channels that are associated with this account.
     */
    suspend fun listChannels(input: ListChannelsRequest = ListChannelsRequest {}): ListChannelsResponse

    /**
     * lists all the live sources in a source location.
     */
    suspend fun listLiveSources(input: ListLiveSourcesRequest): ListLiveSourcesResponse

    /**
     * Returns a list of the playback configurations defined in AWS Elemental MediaTailor. You can specify a maximum number of configurations to return at a time. The default maximum is 50. Results are returned in pagefuls. If MediaTailor has more configurations than the specified maximum, it provides parameters in the response that you can use to retrieve the next pageful.
     */
    suspend fun listPlaybackConfigurations(input: ListPlaybackConfigurationsRequest = ListPlaybackConfigurationsRequest {}): ListPlaybackConfigurationsResponse

    /**
     * Creates a new prefetch schedule.
     */
    suspend fun listPrefetchSchedules(input: ListPrefetchSchedulesRequest): ListPrefetchSchedulesResponse

    /**
     * Retrieves a list of source locations.
     */
    suspend fun listSourceLocations(input: ListSourceLocationsRequest = ListSourceLocationsRequest {}): ListSourceLocationsResponse

    /**
     * Returns a list of the tags assigned to the specified playback configuration resource.
     */
    suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Lists all the VOD sources in a source location.
     */
    suspend fun listVodSources(input: ListVodSourcesRequest): ListVodSourcesResponse

    /**
     * Creates an IAM policy for the channel.
     */
    suspend fun putChannelPolicy(input: PutChannelPolicyRequest): PutChannelPolicyResponse

    /**
     * Adds a new playback configuration to AWS Elemental MediaTailor.
     */
    suspend fun putPlaybackConfiguration(input: PutPlaybackConfigurationRequest = PutPlaybackConfigurationRequest {}): PutPlaybackConfigurationResponse

    /**
     * Starts a specific channel.
     */
    suspend fun startChannel(input: StartChannelRequest): StartChannelResponse

    /**
     * Stops a specific channel.
     */
    suspend fun stopChannel(input: StopChannelRequest): StopChannelResponse

    /**
     * Adds tags to the specified playback configuration resource. You can specify one or more tags to add.
     */
    suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes tags from the specified playback configuration resource. You can specify one or more tags to remove.
     */
    suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates an existing channel.
     */
    suspend fun updateChannel(input: UpdateChannelRequest): UpdateChannelResponse

    /**
     * Updates a specific live source in a specific source location.
     */
    suspend fun updateLiveSource(input: UpdateLiveSourceRequest): UpdateLiveSourceResponse

    /**
     * Updates a source location on a specific channel.
     */
    suspend fun updateSourceLocation(input: UpdateSourceLocationRequest): UpdateSourceLocationResponse

    /**
     * Updates a specific VOD source in a specific source location.
     */
    suspend fun updateVodSource(input: UpdateVodSourceRequest): UpdateVodSourceResponse
}

/**
 * Configures Amazon CloudWatch log settings for a playback configuration.
 */
suspend inline fun MediaTailorClient.configureLogsForPlaybackConfiguration(crossinline block: ConfigureLogsForPlaybackConfigurationRequest.Builder.() -> Unit) = configureLogsForPlaybackConfiguration(ConfigureLogsForPlaybackConfigurationRequest.Builder().apply(block).build())

/**
 * Creates a channel.
 */
suspend inline fun MediaTailorClient.createChannel(crossinline block: CreateChannelRequest.Builder.() -> Unit) = createChannel(CreateChannelRequest.Builder().apply(block).build())

/**
 * Creates name for a specific live source in a source location.
 */
suspend inline fun MediaTailorClient.createLiveSource(crossinline block: CreateLiveSourceRequest.Builder.() -> Unit) = createLiveSource(CreateLiveSourceRequest.Builder().apply(block).build())

/**
 * Creates a new prefetch schedule for the specified playback configuration.
 */
suspend inline fun MediaTailorClient.createPrefetchSchedule(crossinline block: CreatePrefetchScheduleRequest.Builder.() -> Unit) = createPrefetchSchedule(CreatePrefetchScheduleRequest.Builder().apply(block).build())

/**
 * Creates a program.
 */
suspend inline fun MediaTailorClient.createProgram(crossinline block: CreateProgramRequest.Builder.() -> Unit) = createProgram(CreateProgramRequest.Builder().apply(block).build())

/**
 * Creates a source location on a specific channel.
 */
suspend inline fun MediaTailorClient.createSourceLocation(crossinline block: CreateSourceLocationRequest.Builder.() -> Unit) = createSourceLocation(CreateSourceLocationRequest.Builder().apply(block).build())

/**
 * Creates name for a specific VOD source in a source location.
 */
suspend inline fun MediaTailorClient.createVodSource(crossinline block: CreateVodSourceRequest.Builder.() -> Unit) = createVodSource(CreateVodSourceRequest.Builder().apply(block).build())

/**
 * Deletes a channel. You must stop the channel before it can be deleted.
 */
suspend inline fun MediaTailorClient.deleteChannel(crossinline block: DeleteChannelRequest.Builder.() -> Unit) = deleteChannel(DeleteChannelRequest.Builder().apply(block).build())

/**
 * Deletes a channel's IAM policy.
 */
suspend inline fun MediaTailorClient.deleteChannelPolicy(crossinline block: DeleteChannelPolicyRequest.Builder.() -> Unit) = deleteChannelPolicy(DeleteChannelPolicyRequest.Builder().apply(block).build())

/**
 * Deletes a specific live source in a specific source location.
 */
suspend inline fun MediaTailorClient.deleteLiveSource(crossinline block: DeleteLiveSourceRequest.Builder.() -> Unit) = deleteLiveSource(DeleteLiveSourceRequest.Builder().apply(block).build())

/**
 * Deletes the playback configuration for the specified name.
 */
suspend inline fun MediaTailorClient.deletePlaybackConfiguration(crossinline block: DeletePlaybackConfigurationRequest.Builder.() -> Unit) = deletePlaybackConfiguration(DeletePlaybackConfigurationRequest.Builder().apply(block).build())

/**
 * Deletes a prefetch schedule for a specific playback configuration. If you call DeletePrefetchSchedule on an expired prefetch schedule, MediaTailor returns an HTTP 404 status code.
 */
suspend inline fun MediaTailorClient.deletePrefetchSchedule(crossinline block: DeletePrefetchScheduleRequest.Builder.() -> Unit) = deletePrefetchSchedule(DeletePrefetchScheduleRequest.Builder().apply(block).build())

/**
 * Deletes a specific program on a specific channel.
 */
suspend inline fun MediaTailorClient.deleteProgram(crossinline block: DeleteProgramRequest.Builder.() -> Unit) = deleteProgram(DeleteProgramRequest.Builder().apply(block).build())

/**
 * Deletes a source location on a specific channel.
 */
suspend inline fun MediaTailorClient.deleteSourceLocation(crossinline block: DeleteSourceLocationRequest.Builder.() -> Unit) = deleteSourceLocation(DeleteSourceLocationRequest.Builder().apply(block).build())

/**
 * Deletes a specific VOD source in a specific source location.
 */
suspend inline fun MediaTailorClient.deleteVodSource(crossinline block: DeleteVodSourceRequest.Builder.() -> Unit) = deleteVodSource(DeleteVodSourceRequest.Builder().apply(block).build())

/**
 * Describes the properties of a specific channel.
 */
suspend inline fun MediaTailorClient.describeChannel(crossinline block: DescribeChannelRequest.Builder.() -> Unit) = describeChannel(DescribeChannelRequest.Builder().apply(block).build())

/**
 * Provides details about a specific live source in a specific source location.
 */
suspend inline fun MediaTailorClient.describeLiveSource(crossinline block: DescribeLiveSourceRequest.Builder.() -> Unit) = describeLiveSource(DescribeLiveSourceRequest.Builder().apply(block).build())

/**
 * Retrieves the properties of the requested program.
 */
suspend inline fun MediaTailorClient.describeProgram(crossinline block: DescribeProgramRequest.Builder.() -> Unit) = describeProgram(DescribeProgramRequest.Builder().apply(block).build())

/**
 * Retrieves the properties of the requested source location.
 */
suspend inline fun MediaTailorClient.describeSourceLocation(crossinline block: DescribeSourceLocationRequest.Builder.() -> Unit) = describeSourceLocation(DescribeSourceLocationRequest.Builder().apply(block).build())

/**
 * Provides details about a specific VOD source in a specific source location.
 */
suspend inline fun MediaTailorClient.describeVodSource(crossinline block: DescribeVodSourceRequest.Builder.() -> Unit) = describeVodSource(DescribeVodSourceRequest.Builder().apply(block).build())

/**
 * Retrieves information about a channel's IAM policy.
 */
suspend inline fun MediaTailorClient.getChannelPolicy(crossinline block: GetChannelPolicyRequest.Builder.() -> Unit) = getChannelPolicy(GetChannelPolicyRequest.Builder().apply(block).build())

/**
 * Retrieves information about your channel's schedule.
 */
suspend inline fun MediaTailorClient.getChannelSchedule(crossinline block: GetChannelScheduleRequest.Builder.() -> Unit) = getChannelSchedule(GetChannelScheduleRequest.Builder().apply(block).build())

/**
 * Returns the playback configuration for the specified name.
 */
suspend inline fun MediaTailorClient.getPlaybackConfiguration(crossinline block: GetPlaybackConfigurationRequest.Builder.() -> Unit) = getPlaybackConfiguration(GetPlaybackConfigurationRequest.Builder().apply(block).build())

/**
 * Returns information about the prefetch schedule for a specific playback configuration. If you call GetPrefetchSchedule on an expired prefetch schedule, MediaTailor returns an HTTP 404 status code.
 */
suspend inline fun MediaTailorClient.getPrefetchSchedule(crossinline block: GetPrefetchScheduleRequest.Builder.() -> Unit) = getPrefetchSchedule(GetPrefetchScheduleRequest.Builder().apply(block).build())

/**
 * Returns a list of alerts for the given resource.
 */
suspend inline fun MediaTailorClient.listAlerts(crossinline block: ListAlertsRequest.Builder.() -> Unit) = listAlerts(ListAlertsRequest.Builder().apply(block).build())

/**
 * Retrieves a list of channels that are associated with this account.
 */
suspend inline fun MediaTailorClient.listChannels(crossinline block: ListChannelsRequest.Builder.() -> Unit) = listChannels(ListChannelsRequest.Builder().apply(block).build())

/**
 * lists all the live sources in a source location.
 */
suspend inline fun MediaTailorClient.listLiveSources(crossinline block: ListLiveSourcesRequest.Builder.() -> Unit) = listLiveSources(ListLiveSourcesRequest.Builder().apply(block).build())

/**
 * Returns a list of the playback configurations defined in AWS Elemental MediaTailor. You can specify a maximum number of configurations to return at a time. The default maximum is 50. Results are returned in pagefuls. If MediaTailor has more configurations than the specified maximum, it provides parameters in the response that you can use to retrieve the next pageful.
 */
suspend inline fun MediaTailorClient.listPlaybackConfigurations(crossinline block: ListPlaybackConfigurationsRequest.Builder.() -> Unit) = listPlaybackConfigurations(ListPlaybackConfigurationsRequest.Builder().apply(block).build())

/**
 * Creates a new prefetch schedule.
 */
suspend inline fun MediaTailorClient.listPrefetchSchedules(crossinline block: ListPrefetchSchedulesRequest.Builder.() -> Unit) = listPrefetchSchedules(ListPrefetchSchedulesRequest.Builder().apply(block).build())

/**
 * Retrieves a list of source locations.
 */
suspend inline fun MediaTailorClient.listSourceLocations(crossinline block: ListSourceLocationsRequest.Builder.() -> Unit) = listSourceLocations(ListSourceLocationsRequest.Builder().apply(block).build())

/**
 * Returns a list of the tags assigned to the specified playback configuration resource.
 */
suspend inline fun MediaTailorClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit) = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Lists all the VOD sources in a source location.
 */
suspend inline fun MediaTailorClient.listVodSources(crossinline block: ListVodSourcesRequest.Builder.() -> Unit) = listVodSources(ListVodSourcesRequest.Builder().apply(block).build())

/**
 * Creates an IAM policy for the channel.
 */
suspend inline fun MediaTailorClient.putChannelPolicy(crossinline block: PutChannelPolicyRequest.Builder.() -> Unit) = putChannelPolicy(PutChannelPolicyRequest.Builder().apply(block).build())

/**
 * Adds a new playback configuration to AWS Elemental MediaTailor.
 */
suspend inline fun MediaTailorClient.putPlaybackConfiguration(crossinline block: PutPlaybackConfigurationRequest.Builder.() -> Unit) = putPlaybackConfiguration(PutPlaybackConfigurationRequest.Builder().apply(block).build())

/**
 * Starts a specific channel.
 */
suspend inline fun MediaTailorClient.startChannel(crossinline block: StartChannelRequest.Builder.() -> Unit) = startChannel(StartChannelRequest.Builder().apply(block).build())

/**
 * Stops a specific channel.
 */
suspend inline fun MediaTailorClient.stopChannel(crossinline block: StopChannelRequest.Builder.() -> Unit) = stopChannel(StopChannelRequest.Builder().apply(block).build())

/**
 * Adds tags to the specified playback configuration resource. You can specify one or more tags to add.
 */
suspend inline fun MediaTailorClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit) = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes tags from the specified playback configuration resource. You can specify one or more tags to remove.
 */
suspend inline fun MediaTailorClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit) = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates an existing channel.
 */
suspend inline fun MediaTailorClient.updateChannel(crossinline block: UpdateChannelRequest.Builder.() -> Unit) = updateChannel(UpdateChannelRequest.Builder().apply(block).build())

/**
 * Updates a specific live source in a specific source location.
 */
suspend inline fun MediaTailorClient.updateLiveSource(crossinline block: UpdateLiveSourceRequest.Builder.() -> Unit) = updateLiveSource(UpdateLiveSourceRequest.Builder().apply(block).build())

/**
 * Updates a source location on a specific channel.
 */
suspend inline fun MediaTailorClient.updateSourceLocation(crossinline block: UpdateSourceLocationRequest.Builder.() -> Unit) = updateSourceLocation(UpdateSourceLocationRequest.Builder().apply(block).build())

/**
 * Updates a specific VOD source in a specific source location.
 */
suspend inline fun MediaTailorClient.updateVodSource(crossinline block: UpdateVodSourceRequest.Builder.() -> Unit) = updateVodSource(UpdateVodSourceRequest.Builder().apply(block).build())
