// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediatailor.transform

import aws.sdk.kotlin.services.mediatailor.model.CreatePrefetchScheduleRequest
import aws.sdk.kotlin.services.mediatailor.model.PrefetchConsumption
import aws.sdk.kotlin.services.mediatailor.model.PrefetchRetrieval
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreatePrefetchScheduleOperationSerializer: HttpSerialize<CreatePrefetchScheduleRequest> {
    override suspend fun serialize(context: ExecutionContext, input: CreatePrefetchScheduleRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            val pathSegments = listOf(
                "prefetchSchedule",
                "${input.playbackConfigurationName}".encodeLabel(),
                "${input.name}".encodeLabel(),
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializeCreatePrefetchScheduleOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCreatePrefetchScheduleOperationBody(context: ExecutionContext, input: CreatePrefetchScheduleRequest): ByteArray {
    val serializer = JsonSerializer()
    val CONSUMPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Consumption"))
    val RETRIEVAL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Retrieval"))
    val STREAMID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("StreamId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CONSUMPTION_DESCRIPTOR)
        field(RETRIEVAL_DESCRIPTOR)
        field(STREAMID_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.consumption?.let { field(CONSUMPTION_DESCRIPTOR, it, ::serializePrefetchConsumptionDocument) }
        input.retrieval?.let { field(RETRIEVAL_DESCRIPTOR, it, ::serializePrefetchRetrievalDocument) }
        input.streamId?.let { field(STREAMID_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
