// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediatailor.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.mediatailor.model.ConfigureLogsForPlaybackConfigurationResponse
import aws.sdk.kotlin.services.mediatailor.model.MediaTailorException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class ConfigureLogsForPlaybackConfigurationOperationDeserializer: HttpDeserialize<ConfigureLogsForPlaybackConfigurationResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): ConfigureLogsForPlaybackConfigurationResponse {
        if (!response.status.isSuccess()) {
            throwConfigureLogsForPlaybackConfigurationError(context, response)
        }
        val builder = ConfigureLogsForPlaybackConfigurationResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeConfigureLogsForPlaybackConfigurationOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwConfigureLogsForPlaybackConfigurationError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw MediaTailorException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        else -> MediaTailorException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeConfigureLogsForPlaybackConfigurationOperationBody(builder: ConfigureLogsForPlaybackConfigurationResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val PERCENTENABLED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("PercentEnabled"))
    val PLAYBACKCONFIGURATIONNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("PlaybackConfigurationName"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(PERCENTENABLED_DESCRIPTOR)
        field(PLAYBACKCONFIGURATIONNAME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                PERCENTENABLED_DESCRIPTOR.index -> builder.percentEnabled = deserializeInt()
                PLAYBACKCONFIGURATIONNAME_DESCRIPTOR.index -> builder.playbackConfigurationName = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
