// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediatailor.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A complex type that contains settings that determine how and when that MediaTailor places prefetched ads into upcoming ad breaks.
 */
class PrefetchConsumption private constructor(builder: Builder) {
    /**
     * If you only want MediaTailor to insert prefetched ads into avails (ad breaks) that match specific dynamic variables, such as scte.event_id, set the avail matching criteria.
     */
    val availMatchingCriteria: List<AvailMatchingCriteria>? = builder.availMatchingCriteria
    /**
     * The time when MediaTailor no longer considers the prefetched ads for use in an ad break. MediaTailor automatically deletes prefetch schedules no less than seven days after the end time. If you'd like to manually delete the prefetch schedule, you can call DeletePrefetchSchedule.
     */
    val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * The time when prefetched ads are considered for use in an ad break. If you don't specify StartTime, the prefetched ads are available after MediaTailor retrives them from the ad decision server.
     */
    val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediatailor.model.PrefetchConsumption = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PrefetchConsumption(")
        append("availMatchingCriteria=$availMatchingCriteria,")
        append("endTime=$endTime,")
        append("startTime=$startTime)")
    }

    override fun hashCode(): kotlin.Int {
        var result = availMatchingCriteria?.hashCode() ?: 0
        result = 31 * result + (endTime?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PrefetchConsumption

        if (availMatchingCriteria != other.availMatchingCriteria) return false
        if (endTime != other.endTime) return false
        if (startTime != other.startTime) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediatailor.model.PrefetchConsumption = Builder(this).apply(block).build()

    class Builder {
        /**
         * If you only want MediaTailor to insert prefetched ads into avails (ad breaks) that match specific dynamic variables, such as scte.event_id, set the avail matching criteria.
         */
        var availMatchingCriteria: List<AvailMatchingCriteria>? = null
        /**
         * The time when MediaTailor no longer considers the prefetched ads for use in an ad break. MediaTailor automatically deletes prefetch schedules no less than seven days after the end time. If you'd like to manually delete the prefetch schedule, you can call DeletePrefetchSchedule.
         */
        var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The time when prefetched ads are considered for use in an ad break. If you don't specify StartTime, the prefetched ads are available after MediaTailor retrives them from the ad decision server.
         */
        var startTime: aws.smithy.kotlin.runtime.time.Instant? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediatailor.model.PrefetchConsumption) : this() {
            this.availMatchingCriteria = x.availMatchingCriteria
            this.endTime = x.endTime
            this.startTime = x.startTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediatailor.model.PrefetchConsumption = PrefetchConsumption(this)
    }
}
