// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediatailor.model



class CreatePrefetchScheduleRequest private constructor(builder: Builder) {
    /**
     * The configuration settings for MediaTailor's *consumption* of the prefetched ads from the ad decision server. Each consumption configuration contains an end time and an optional start time that define the *consumption window*. Prefetch schedules automatically expire no earlier than seven days after the end time.
     */
    val consumption: aws.sdk.kotlin.services.mediatailor.model.PrefetchConsumption? = builder.consumption
    /**
     * The identifier for the playback configuration.
     */
    val name: kotlin.String? = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The name of the playback configuration.
     */
    val playbackConfigurationName: kotlin.String? = requireNotNull(builder.playbackConfigurationName) { "A non-null value must be provided for playbackConfigurationName" }
    /**
     * The configuration settings for retrieval of prefetched ads from the ad decision server. Only one set of prefetched ads will be retrieved and subsequently consumed for each ad break.
     */
    val retrieval: aws.sdk.kotlin.services.mediatailor.model.PrefetchRetrieval? = builder.retrieval
    /**
     * An optional stream identifier that MediaTailor uses to prefetch ads for multiple streams that use the same playback configuration. If StreamId is specified, MediaTailor returns all of the prefetch schedules with an exact match on StreamId. If not specified, MediaTailor returns all of the prefetch schedules for the playback configuration, regardless of StreamId.
     */
    val streamId: kotlin.String? = builder.streamId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediatailor.model.CreatePrefetchScheduleRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreatePrefetchScheduleRequest(")
        append("consumption=$consumption,")
        append("name=$name,")
        append("playbackConfigurationName=$playbackConfigurationName,")
        append("retrieval=$retrieval,")
        append("streamId=$streamId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = consumption?.hashCode() ?: 0
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (playbackConfigurationName?.hashCode() ?: 0)
        result = 31 * result + (retrieval?.hashCode() ?: 0)
        result = 31 * result + (streamId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreatePrefetchScheduleRequest

        if (consumption != other.consumption) return false
        if (name != other.name) return false
        if (playbackConfigurationName != other.playbackConfigurationName) return false
        if (retrieval != other.retrieval) return false
        if (streamId != other.streamId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediatailor.model.CreatePrefetchScheduleRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The configuration settings for MediaTailor's *consumption* of the prefetched ads from the ad decision server. Each consumption configuration contains an end time and an optional start time that define the *consumption window*. Prefetch schedules automatically expire no earlier than seven days after the end time.
         */
        var consumption: aws.sdk.kotlin.services.mediatailor.model.PrefetchConsumption? = null
        /**
         * The identifier for the playback configuration.
         */
        var name: kotlin.String? = null
        /**
         * The name of the playback configuration.
         */
        var playbackConfigurationName: kotlin.String? = null
        /**
         * The configuration settings for retrieval of prefetched ads from the ad decision server. Only one set of prefetched ads will be retrieved and subsequently consumed for each ad break.
         */
        var retrieval: aws.sdk.kotlin.services.mediatailor.model.PrefetchRetrieval? = null
        /**
         * An optional stream identifier that MediaTailor uses to prefetch ads for multiple streams that use the same playback configuration. If StreamId is specified, MediaTailor returns all of the prefetch schedules with an exact match on StreamId. If not specified, MediaTailor returns all of the prefetch schedules for the playback configuration, regardless of StreamId.
         */
        var streamId: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediatailor.model.CreatePrefetchScheduleRequest) : this() {
            this.consumption = x.consumption
            this.name = x.name
            this.playbackConfigurationName = x.playbackConfigurationName
            this.retrieval = x.retrieval
            this.streamId = x.streamId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediatailor.model.CreatePrefetchScheduleRequest = CreatePrefetchScheduleRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.mediatailor.model.PrefetchConsumption] inside the given [block]
         */
        fun consumption(block: aws.sdk.kotlin.services.mediatailor.model.PrefetchConsumption.Builder.() -> kotlin.Unit) {
            this.consumption = aws.sdk.kotlin.services.mediatailor.model.PrefetchConsumption.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediatailor.model.PrefetchRetrieval] inside the given [block]
         */
        fun retrieval(block: aws.sdk.kotlin.services.mediatailor.model.PrefetchRetrieval.Builder.() -> kotlin.Unit) {
            this.retrieval = aws.sdk.kotlin.services.mediatailor.model.PrefetchRetrieval.invoke(block)
        }
    }
}
