// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediatailor.model



class CreateChannelRequest private constructor(builder: Builder) {
    /**
     * The identifier for the channel you are working on.
     */
    val channelName: kotlin.String? = requireNotNull(builder.channelName) { "A non-null value must be provided for channelName" }
    /**
     * The slate used to fill gaps between programs in the schedule. You must configure filler slate if your channel uses the LINEAR PlaybackMode. MediaTailor doesn't support filler slate for channels using the LOOP PlaybackMode.
     */
    val fillerSlate: aws.sdk.kotlin.services.mediatailor.model.SlateSource? = builder.fillerSlate
    /**
     * The channel's output properties.
     */
    val outputs: List<RequestOutputItem>? = builder.outputs
    /**
     * The type of playback mode to use for this channel.
     *
     * LINEAR - The programs in the schedule play once back-to-back in the schedule.
     *
     * LOOP - The programs in the schedule play back-to-back in an endless loop. When the last program in the schedule stops playing, playback loops back to the first program in the schedule.
     */
    val playbackMode: aws.sdk.kotlin.services.mediatailor.model.PlaybackMode? = builder.playbackMode
    /**
     * The tags to assign to the channel.
     */
    val tags: Map<String, String>? = builder.tags
    /**
     * The tier of the channel.
     */
    val tier: aws.sdk.kotlin.services.mediatailor.model.Tier? = builder.tier

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediatailor.model.CreateChannelRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateChannelRequest(")
        append("channelName=$channelName,")
        append("fillerSlate=$fillerSlate,")
        append("outputs=$outputs,")
        append("playbackMode=$playbackMode,")
        append("tags=$tags,")
        append("tier=$tier)")
    }

    override fun hashCode(): kotlin.Int {
        var result = channelName?.hashCode() ?: 0
        result = 31 * result + (fillerSlate?.hashCode() ?: 0)
        result = 31 * result + (outputs?.hashCode() ?: 0)
        result = 31 * result + (playbackMode?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (tier?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateChannelRequest

        if (channelName != other.channelName) return false
        if (fillerSlate != other.fillerSlate) return false
        if (outputs != other.outputs) return false
        if (playbackMode != other.playbackMode) return false
        if (tags != other.tags) return false
        if (tier != other.tier) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediatailor.model.CreateChannelRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The identifier for the channel you are working on.
         */
        var channelName: kotlin.String? = null
        /**
         * The slate used to fill gaps between programs in the schedule. You must configure filler slate if your channel uses the LINEAR PlaybackMode. MediaTailor doesn't support filler slate for channels using the LOOP PlaybackMode.
         */
        var fillerSlate: aws.sdk.kotlin.services.mediatailor.model.SlateSource? = null
        /**
         * The channel's output properties.
         */
        var outputs: List<RequestOutputItem>? = null
        /**
         * The type of playback mode to use for this channel.
         *
         * LINEAR - The programs in the schedule play once back-to-back in the schedule.
         *
         * LOOP - The programs in the schedule play back-to-back in an endless loop. When the last program in the schedule stops playing, playback loops back to the first program in the schedule.
         */
        var playbackMode: aws.sdk.kotlin.services.mediatailor.model.PlaybackMode? = null
        /**
         * The tags to assign to the channel.
         */
        var tags: Map<String, String>? = null
        /**
         * The tier of the channel.
         */
        var tier: aws.sdk.kotlin.services.mediatailor.model.Tier? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediatailor.model.CreateChannelRequest) : this() {
            this.channelName = x.channelName
            this.fillerSlate = x.fillerSlate
            this.outputs = x.outputs
            this.playbackMode = x.playbackMode
            this.tags = x.tags
            this.tier = x.tier
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediatailor.model.CreateChannelRequest = CreateChannelRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.mediatailor.model.SlateSource] inside the given [block]
         */
        fun fillerSlate(block: aws.sdk.kotlin.services.mediatailor.model.SlateSource.Builder.() -> kotlin.Unit) {
            this.fillerSlate = aws.sdk.kotlin.services.mediatailor.model.SlateSource.invoke(block)
        }
    }
}
