// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediatailor.model



/**
 * Configures Amazon CloudWatch log settings for a playback configuration.
 */
class ConfigureLogsForPlaybackConfigurationRequest private constructor(builder: Builder) {
    /**
     * The percentage of session logs that MediaTailor sends to your Cloudwatch Logs account. For example, if your playback configuration has 1000 sessions and percentEnabled is set to 60, MediaTailor sends logs for 600 of the sessions to CloudWatch Logs. MediaTailor decides at random which of the playback configuration sessions to send logs for. If you want to view logs for a specific session, you can use the [debug log mode](https://docs.aws.amazon.com/mediatailor/latest/ug/debug-log-mode.html).
     *
     * Valid values: 0 - 100
     */
    val percentEnabled: kotlin.Int? = builder.percentEnabled
    /**
     * The name of the playback configuration.
     */
    val playbackConfigurationName: kotlin.String? = builder.playbackConfigurationName

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediatailor.model.ConfigureLogsForPlaybackConfigurationRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ConfigureLogsForPlaybackConfigurationRequest(")
        append("percentEnabled=$percentEnabled,")
        append("playbackConfigurationName=$playbackConfigurationName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = percentEnabled ?: 0
        result = 31 * result + (playbackConfigurationName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ConfigureLogsForPlaybackConfigurationRequest

        if (percentEnabled != other.percentEnabled) return false
        if (playbackConfigurationName != other.playbackConfigurationName) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediatailor.model.ConfigureLogsForPlaybackConfigurationRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The percentage of session logs that MediaTailor sends to your Cloudwatch Logs account. For example, if your playback configuration has 1000 sessions and percentEnabled is set to 60, MediaTailor sends logs for 600 of the sessions to CloudWatch Logs. MediaTailor decides at random which of the playback configuration sessions to send logs for. If you want to view logs for a specific session, you can use the [debug log mode](https://docs.aws.amazon.com/mediatailor/latest/ug/debug-log-mode.html).
         *
         * Valid values: 0 - 100
         */
        var percentEnabled: kotlin.Int? = null
        /**
         * The name of the playback configuration.
         */
        var playbackConfigurationName: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediatailor.model.ConfigureLogsForPlaybackConfigurationRequest) : this() {
            this.percentEnabled = x.percentEnabled
            this.playbackConfigurationName = x.playbackConfigurationName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediatailor.model.ConfigureLogsForPlaybackConfigurationRequest = ConfigureLogsForPlaybackConfigurationRequest(this)
    }
}
