// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediatailor.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The configuration parameters for a channel.
 */
class Channel private constructor(builder: Builder) {
    /**
     * The ARN of the channel.
     */
    val arn: kotlin.String? = builder.arn
    /**
     * The name of the channel.
     */
    val channelName: kotlin.String? = builder.channelName
    /**
     * Returns the state whether the channel is running or not.
     */
    val channelState: kotlin.String? = builder.channelState
    /**
     * The timestamp of when the channel was created.
     */
    val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The slate used to fill gaps between programs in the schedule. You must configure filler slate if your channel uses the LINEAR PlaybackMode. MediaTailor doesn't support filler slate for channels using the LOOP PlaybackMode.
     */
    val fillerSlate: aws.sdk.kotlin.services.mediatailor.model.SlateSource? = builder.fillerSlate
    /**
     * The timestamp of when the channel was last modified.
     */
    val lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedTime
    /**
     * The channel's output properties.
     */
    val outputs: List<ResponseOutputItem>? = builder.outputs
    /**
     * The type of playback mode for this channel.
     *
     * LINEAR - Programs play back-to-back only once.
     *
     * LOOP - Programs play back-to-back in an endless loop. When the last program in the schedule plays, playback loops back to the first program in the schedule.
     */
    val playbackMode: kotlin.String? = builder.playbackMode
    /**
     * The tags to assign to the channel.
     */
    val tags: Map<String, String>? = builder.tags
    /**
     * The tier for this channel. STANDARD tier channels can contain live programs.
     */
    val tier: kotlin.String? = builder.tier

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediatailor.model.Channel = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Channel(")
        append("arn=$arn,")
        append("channelName=$channelName,")
        append("channelState=$channelState,")
        append("creationTime=$creationTime,")
        append("fillerSlate=$fillerSlate,")
        append("lastModifiedTime=$lastModifiedTime,")
        append("outputs=$outputs,")
        append("playbackMode=$playbackMode,")
        append("tags=$tags,")
        append("tier=$tier)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (channelName?.hashCode() ?: 0)
        result = 31 * result + (channelState?.hashCode() ?: 0)
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (fillerSlate?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedTime?.hashCode() ?: 0)
        result = 31 * result + (outputs?.hashCode() ?: 0)
        result = 31 * result + (playbackMode?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (tier?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Channel

        if (arn != other.arn) return false
        if (channelName != other.channelName) return false
        if (channelState != other.channelState) return false
        if (creationTime != other.creationTime) return false
        if (fillerSlate != other.fillerSlate) return false
        if (lastModifiedTime != other.lastModifiedTime) return false
        if (outputs != other.outputs) return false
        if (playbackMode != other.playbackMode) return false
        if (tags != other.tags) return false
        if (tier != other.tier) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediatailor.model.Channel = Builder(this).apply(block).build()

    class Builder {
        /**
         * The ARN of the channel.
         */
        var arn: kotlin.String? = null
        /**
         * The name of the channel.
         */
        var channelName: kotlin.String? = null
        /**
         * Returns the state whether the channel is running or not.
         */
        var channelState: kotlin.String? = null
        /**
         * The timestamp of when the channel was created.
         */
        var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The slate used to fill gaps between programs in the schedule. You must configure filler slate if your channel uses the LINEAR PlaybackMode. MediaTailor doesn't support filler slate for channels using the LOOP PlaybackMode.
         */
        var fillerSlate: aws.sdk.kotlin.services.mediatailor.model.SlateSource? = null
        /**
         * The timestamp of when the channel was last modified.
         */
        var lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The channel's output properties.
         */
        var outputs: List<ResponseOutputItem>? = null
        /**
         * The type of playback mode for this channel.
         *
         * LINEAR - Programs play back-to-back only once.
         *
         * LOOP - Programs play back-to-back in an endless loop. When the last program in the schedule plays, playback loops back to the first program in the schedule.
         */
        var playbackMode: kotlin.String? = null
        /**
         * The tags to assign to the channel.
         */
        var tags: Map<String, String>? = null
        /**
         * The tier for this channel. STANDARD tier channels can contain live programs.
         */
        var tier: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediatailor.model.Channel) : this() {
            this.arn = x.arn
            this.channelName = x.channelName
            this.channelState = x.channelState
            this.creationTime = x.creationTime
            this.fillerSlate = x.fillerSlate
            this.lastModifiedTime = x.lastModifiedTime
            this.outputs = x.outputs
            this.playbackMode = x.playbackMode
            this.tags = x.tags
            this.tier = x.tier
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediatailor.model.Channel = Channel(this)

        /**
         * construct an [aws.sdk.kotlin.services.mediatailor.model.SlateSource] inside the given [block]
         */
        fun fillerSlate(block: aws.sdk.kotlin.services.mediatailor.model.SlateSource.Builder.() -> kotlin.Unit) {
            this.fillerSlate = aws.sdk.kotlin.services.mediatailor.model.SlateSource.invoke(block)
        }
    }
}
