// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediatailor.model



/**
 * MediaTailor only places (consumes) prefetched ads if the ad break meets the criteria defined by the dynamic variables. This gives you granular control over which ad break to place the prefetched ads into.
 *
 * As an example, let's say that you set DynamicVariable to scte.event_id and Operator to EQUALS, and your playback configuration has an ADS URL of https://my.ads.server.com/path?&podId=&#91;scte.avail_num&#93;&event=&#91;scte.event_id&#93;&duration=&#91;session.avail_duration_secs&#93;. And the prefetch request to the ADS contains these values https://my.ads.server.com/path?&podId=3&event=my-awesome-event&duration=30. MediaTailor will only insert the prefetched ads into the ad break if has a SCTE marker with an event id of my-awesome-event, since it must match the event id that MediaTailor uses to query the ADS.
 *
 * You can specify up to five AvailMatchingCriteria. If you specify multiple AvailMatchingCriteria, MediaTailor combines them to match using a logical AND. You can model logical OR combinations by creating multiple prefetch schedules.
 */
class AvailMatchingCriteria private constructor(builder: Builder) {
    /**
     * The dynamic variable(s) that MediaTailor should use as avail matching criteria. MediaTailor only places the prefetched ads into the avail if the avail matches the criteria defined by the dynamic variable. For information about dynamic variables, see [Using dynamic ad variables](https://docs.aws.amazon.com/mediatailor/latest/ug/variables.html) in the *MediaTailor User Guide*.
     *
     * You can include up to 100 dynamic variables.
     */
    val dynamicVariable: kotlin.String? = builder.dynamicVariable
    /**
     * For the DynamicVariable specified in AvailMatchingCriteria, the Operator that is used for the comparison.
     */
    val operator: aws.sdk.kotlin.services.mediatailor.model.Operator? = builder.operator

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediatailor.model.AvailMatchingCriteria = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AvailMatchingCriteria(")
        append("dynamicVariable=$dynamicVariable,")
        append("operator=$operator)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dynamicVariable?.hashCode() ?: 0
        result = 31 * result + (operator?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AvailMatchingCriteria

        if (dynamicVariable != other.dynamicVariable) return false
        if (operator != other.operator) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediatailor.model.AvailMatchingCriteria = Builder(this).apply(block).build()

    class Builder {
        /**
         * The dynamic variable(s) that MediaTailor should use as avail matching criteria. MediaTailor only places the prefetched ads into the avail if the avail matches the criteria defined by the dynamic variable. For information about dynamic variables, see [Using dynamic ad variables](https://docs.aws.amazon.com/mediatailor/latest/ug/variables.html) in the *MediaTailor User Guide*.
         *
         * You can include up to 100 dynamic variables.
         */
        var dynamicVariable: kotlin.String? = null
        /**
         * For the DynamicVariable specified in AvailMatchingCriteria, the Operator that is used for the comparison.
         */
        var operator: aws.sdk.kotlin.services.mediatailor.model.Operator? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediatailor.model.AvailMatchingCriteria) : this() {
            this.dynamicVariable = x.dynamicVariable
            this.operator = x.operator
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediatailor.model.AvailMatchingCriteria = AvailMatchingCriteria(this)
    }
}
