// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediatailor.model



/**
 * Ad break configuration parameters.
 */
class AdBreak private constructor(builder: Builder) {
    /**
     * The SCTE-35 ad insertion type. Accepted value: SPLICE_INSERT.
     */
    val messageType: aws.sdk.kotlin.services.mediatailor.model.MessageType? = builder.messageType
    /**
     * How long (in milliseconds) after the beginning of the program that an ad starts. This value must fall within 100ms of a segment boundary, otherwise the ad break will be skipped.
     */
    val offsetMillis: kotlin.Long? = builder.offsetMillis
    /**
     * Ad break slate configuration.
     */
    val slate: aws.sdk.kotlin.services.mediatailor.model.SlateSource? = builder.slate
    /**
     * This defines the SCTE-35 splice_insert() message inserted around the ad. For information about using splice_insert(), see the SCTE-35 specficiaiton, section 9.7.3.1.
     */
    val spliceInsertMessage: aws.sdk.kotlin.services.mediatailor.model.SpliceInsertMessage? = builder.spliceInsertMessage

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediatailor.model.AdBreak = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AdBreak(")
        append("messageType=$messageType,")
        append("offsetMillis=$offsetMillis,")
        append("slate=$slate,")
        append("spliceInsertMessage=$spliceInsertMessage)")
    }

    override fun hashCode(): kotlin.Int {
        var result = messageType?.hashCode() ?: 0
        result = 31 * result + (offsetMillis?.hashCode() ?: 0)
        result = 31 * result + (slate?.hashCode() ?: 0)
        result = 31 * result + (spliceInsertMessage?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AdBreak

        if (messageType != other.messageType) return false
        if (offsetMillis != other.offsetMillis) return false
        if (slate != other.slate) return false
        if (spliceInsertMessage != other.spliceInsertMessage) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediatailor.model.AdBreak = Builder(this).apply(block).build()

    class Builder {
        /**
         * The SCTE-35 ad insertion type. Accepted value: SPLICE_INSERT.
         */
        var messageType: aws.sdk.kotlin.services.mediatailor.model.MessageType? = null
        /**
         * How long (in milliseconds) after the beginning of the program that an ad starts. This value must fall within 100ms of a segment boundary, otherwise the ad break will be skipped.
         */
        var offsetMillis: kotlin.Long? = null
        /**
         * Ad break slate configuration.
         */
        var slate: aws.sdk.kotlin.services.mediatailor.model.SlateSource? = null
        /**
         * This defines the SCTE-35 splice_insert() message inserted around the ad. For information about using splice_insert(), see the SCTE-35 specficiaiton, section 9.7.3.1.
         */
        var spliceInsertMessage: aws.sdk.kotlin.services.mediatailor.model.SpliceInsertMessage? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediatailor.model.AdBreak) : this() {
            this.messageType = x.messageType
            this.offsetMillis = x.offsetMillis
            this.slate = x.slate
            this.spliceInsertMessage = x.spliceInsertMessage
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediatailor.model.AdBreak = AdBreak(this)

        /**
         * construct an [aws.sdk.kotlin.services.mediatailor.model.SlateSource] inside the given [block]
         */
        fun slate(block: aws.sdk.kotlin.services.mediatailor.model.SlateSource.Builder.() -> kotlin.Unit) {
            this.slate = aws.sdk.kotlin.services.mediatailor.model.SlateSource.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediatailor.model.SpliceInsertMessage] inside the given [block]
         */
        fun spliceInsertMessage(block: aws.sdk.kotlin.services.mediatailor.model.SpliceInsertMessage.Builder.() -> kotlin.Unit) {
            this.spliceInsertMessage = aws.sdk.kotlin.services.mediatailor.model.SpliceInsertMessage.invoke(block)
        }
    }
}
