// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediatailor.model



/**
 * Access configuration parameters.
 */
class AccessConfiguration private constructor(builder: Builder) {
    /**
     * The type of authentication used to access content from HttpConfiguration::BaseUrl on your source location. Accepted value: S3_SIGV4.
     *
     * S3_SIGV4 - AWS Signature Version 4 authentication for Amazon S3 hosted virtual-style access. If your source location base URL is an Amazon S3 bucket, MediaTailor can use AWS Signature Version 4 (SigV4) authentication to access the bucket where your source content is stored. Your MediaTailor source location baseURL must follow the S3 virtual hosted-style request URL format. For example, https://bucket-name.s3.Region.amazonaws.com/key-name.
     *
     * Before you can use S3_SIGV4, you must meet these requirements:
     *
     * • You must allow MediaTailor to access your S3 bucket by granting mediatailor.amazonaws.com principal access in IAM. For information about configuring access in IAM, see Access management in the IAM User Guide.
     *
     * • The mediatailor.amazonaws.com service principal must have permissions to read all top level manifests referenced by the VodSource packaging configurations.
     *
     * • The caller of the API must have s3:GetObject IAM permissions to read all top level manifests referenced by your MediaTailor VodSource packaging configurations.
     */
    val accessType: aws.sdk.kotlin.services.mediatailor.model.AccessType? = builder.accessType
    /**
     * AWS Secrets Manager access token configuration parameters.
     */
    val secretsManagerAccessTokenConfiguration: aws.sdk.kotlin.services.mediatailor.model.SecretsManagerAccessTokenConfiguration? = builder.secretsManagerAccessTokenConfiguration

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediatailor.model.AccessConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AccessConfiguration(")
        append("accessType=$accessType,")
        append("secretsManagerAccessTokenConfiguration=$secretsManagerAccessTokenConfiguration)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessType?.hashCode() ?: 0
        result = 31 * result + (secretsManagerAccessTokenConfiguration?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AccessConfiguration

        if (accessType != other.accessType) return false
        if (secretsManagerAccessTokenConfiguration != other.secretsManagerAccessTokenConfiguration) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediatailor.model.AccessConfiguration = Builder(this).apply(block).build()

    class Builder {
        /**
         * The type of authentication used to access content from HttpConfiguration::BaseUrl on your source location. Accepted value: S3_SIGV4.
         *
         * S3_SIGV4 - AWS Signature Version 4 authentication for Amazon S3 hosted virtual-style access. If your source location base URL is an Amazon S3 bucket, MediaTailor can use AWS Signature Version 4 (SigV4) authentication to access the bucket where your source content is stored. Your MediaTailor source location baseURL must follow the S3 virtual hosted-style request URL format. For example, https://bucket-name.s3.Region.amazonaws.com/key-name.
         *
         * Before you can use S3_SIGV4, you must meet these requirements:
         *
         * • You must allow MediaTailor to access your S3 bucket by granting mediatailor.amazonaws.com principal access in IAM. For information about configuring access in IAM, see Access management in the IAM User Guide.
         *
         * • The mediatailor.amazonaws.com service principal must have permissions to read all top level manifests referenced by the VodSource packaging configurations.
         *
         * • The caller of the API must have s3:GetObject IAM permissions to read all top level manifests referenced by your MediaTailor VodSource packaging configurations.
         */
        var accessType: aws.sdk.kotlin.services.mediatailor.model.AccessType? = null
        /**
         * AWS Secrets Manager access token configuration parameters.
         */
        var secretsManagerAccessTokenConfiguration: aws.sdk.kotlin.services.mediatailor.model.SecretsManagerAccessTokenConfiguration? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediatailor.model.AccessConfiguration) : this() {
            this.accessType = x.accessType
            this.secretsManagerAccessTokenConfiguration = x.secretsManagerAccessTokenConfiguration
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediatailor.model.AccessConfiguration = AccessConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.mediatailor.model.SecretsManagerAccessTokenConfiguration] inside the given [block]
         */
        fun secretsManagerAccessTokenConfiguration(block: aws.sdk.kotlin.services.mediatailor.model.SecretsManagerAccessTokenConfiguration.Builder.() -> kotlin.Unit) {
            this.secretsManagerAccessTokenConfiguration = aws.sdk.kotlin.services.mediatailor.model.SecretsManagerAccessTokenConfiguration.invoke(block)
        }
    }
}
